/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.base.commons.BaseDiscoveryService;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.DefaultTopologyView;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.ViewStateManager;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerFactory;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.ClusterSyncHistory;
import org.apache.sling.discovery.commons.providers.spi.base.ClusterSyncServiceChain;
import org.apache.sling.discovery.commons.providers.spi.base.IdMapService;
import org.apache.sling.discovery.commons.providers.spi.base.OakBacklogClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.SyncTokenService;
import org.apache.sling.discovery.commons.providers.util.PropertyNameHelper;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.oak.Config;
import org.apache.sling.discovery.oak.pinger.OakViewChecker;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DiscoveryService.class, OakDiscoveryService.class})
public class OakDiscoveryService
extends BaseDiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(OakDiscoveryService.class);
    @Reference
    private SlingSettingsService settingsService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=TopologyEventListener.class)
    private TopologyEventListener[] eventListeners = new TopologyEventListener[0];
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=PropertyProvider.class, updated="updatedPropertyProvider")
    private List<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
    private final Object lock = new Object();
    private volatile boolean activated = false;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private OakViewChecker oakViewChecker;
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private ConnectorRegistry connectorRegistry;
    @Reference
    private ClusterViewService clusterViewService;
    @Reference
    private Config config;
    @Reference
    private IdMapService idMapService;
    @Reference
    private OakBacklogClusterSyncService oakBacklogClusterSyncService;
    @Reference
    private SyncTokenService syncTokenService;
    private String slingId;
    private ServiceRegistration mbeanRegistration;
    private ViewStateManager viewStateManager;
    private final ReentrantLock viewStateManagerLock = new ReentrantLock();
    private final List<TopologyEventListener> pendingListeners = new LinkedList<TopologyEventListener>();
    private TopologyEventListener changePropagationListener = new TopologyEventListener(){

        public void handleTopologyEvent(TopologyEvent event) {
            OakViewChecker checker = OakDiscoveryService.this.oakViewChecker;
            if (OakDiscoveryService.this.activated && checker != null && (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED)) {
                logger.info("changePropagationListener.handleTopologyEvent: topology changed - propagate through connectors");
                checker.triggerAsyncConnectorPing();
            }
        }
    };

    public static OakDiscoveryService testConstructor(SlingSettingsService settingsService, AnnouncementRegistry announcementRegistry, ConnectorRegistry connectorRegistry, ClusterViewService clusterViewService, Config config, OakViewChecker connectorPinger, Scheduler scheduler, IdMapService idMapService, OakBacklogClusterSyncService oakBacklogClusterSyncService, SyncTokenService syncTokenService, ResourceResolverFactory factory) {
        OakDiscoveryService discoService = new OakDiscoveryService();
        discoService.settingsService = settingsService;
        discoService.announcementRegistry = announcementRegistry;
        discoService.connectorRegistry = connectorRegistry;
        discoService.clusterViewService = clusterViewService;
        discoService.config = config;
        discoService.oakViewChecker = connectorPinger;
        discoService.scheduler = scheduler;
        discoService.idMapService = idMapService;
        discoService.oakBacklogClusterSyncService = oakBacklogClusterSyncService;
        discoService.syncTokenService = syncTokenService;
        discoService.resourceResolverFactory = factory;
        return discoService;
    }

    protected void handleIsolatedFromTopology() {
        if (this.oakViewChecker != null && this.oakViewChecker.resetLeaderElectionId()) {
            logger.info("getTopology: reset leaderElectionId to force this instance to the end of the instance order (thus incl not to remain leader)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(BundleContext bundleContext) {
        OakBacklogClusterSyncService consistencyService;
        logger.debug("OakDiscoveryService activating...");
        if (this.settingsService == null) {
            throw new IllegalStateException("settingsService not found");
        }
        if (this.oakViewChecker == null) {
            throw new IllegalStateException("heartbeatHandler not found");
        }
        this.slingId = this.settingsService.getSlingId();
        if (this.config.getSyncTokenEnabled()) {
            ClusterSyncHistory consistencyHistory = new ClusterSyncHistory();
            this.oakBacklogClusterSyncService.setConsistencyHistory(consistencyHistory);
            this.syncTokenService.setConsistencyHistory(consistencyHistory);
            consistencyService = new ClusterSyncServiceChain(new ClusterSyncService[]{this.oakBacklogClusterSyncService, this.syncTokenService});
        } else {
            consistencyService = this.oakBacklogClusterSyncService;
        }
        this.viewStateManager = ViewStateManagerFactory.newViewStateManager((Lock)this.viewStateManagerLock, (ClusterSyncService)consistencyService);
        if (this.config.getMinEventDelay() > 0) {
            this.viewStateManager.installMinEventDelayHandler((DiscoveryService)this, this.scheduler, (long)this.config.getMinEventDelay());
        }
        String isolatedClusterId = UUID.randomUUID().toString();
        DefaultClusterView isolatedCluster = new DefaultClusterView(isolatedClusterId);
        HashMap emptyProperties = new HashMap();
        DefaultInstanceDescription isolatedInstance = new DefaultInstanceDescription(isolatedCluster, true, true, this.slingId, emptyProperties);
        ArrayList<DefaultInstanceDescription> col = new ArrayList<DefaultInstanceDescription>();
        col.add(isolatedInstance);
        DefaultTopologyView topology = new DefaultTopologyView();
        topology.addInstances(col);
        topology.setNotCurrent();
        this.setOldView(topology);
        this.setOldView((DefaultTopologyView)this.getTopology());
        this.getOldView().setNotCurrent();
        this.oakViewChecker.initialize(this);
        this.viewStateManagerLock.lock();
        try {
            this.viewStateManager.handleActivated();
            this.doUpdateProperties();
            DefaultTopologyView newView = (DefaultTopologyView)this.getTopology();
            if (newView.isCurrent()) {
                this.viewStateManager.handleNewView((BaseTopologyView)newView);
            } else {
                logger.info("activate: this instance is in isolated mode and must yet finish voting before it can send out TOPOLOGY_INIT.");
            }
            this.activated = true;
            this.setOldView(newView);
            for (TopologyEventListener listener : this.pendingListeners) {
                this.viewStateManager.bind(listener);
            }
            this.pendingListeners.clear();
            this.viewStateManager.bind(this.changePropagationListener);
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
        URL[] topologyConnectorURLs = this.config.getTopologyConnectorURLs();
        if (topologyConnectorURLs != null) {
            for (int i = 0; i < topologyConnectorURLs.length; ++i) {
                URL aURL = topologyConnectorURLs[i];
                if (aURL == null) continue;
                try {
                    logger.info("activate: registering outgoing topology connector to " + aURL);
                    this.connectorRegistry.registerOutgoingConnector(this.clusterViewService, aURL);
                    continue;
                }
                catch (Exception e) {
                    logger.info("activate: could not register url: " + aURL + " due to: " + e, (Throwable)e);
                }
            }
        }
        logger.debug("OakDiscoveryService activated.");
    }

    @Deactivate
    protected void deactivate() {
        logger.debug("OakDiscoveryService deactivated.");
        this.viewStateManagerLock.lock();
        try {
            this.viewStateManager.unbind(this.changePropagationListener);
            this.viewStateManager.handleDeactivated();
            this.activated = false;
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
        try {
            if (this.mbeanRegistration != null) {
                this.mbeanRegistration.unregister();
                this.mbeanRegistration = null;
            }
        }
        catch (Exception e) {
            logger.error("deactivate: Error on unregister: " + e, (Throwable)e);
        }
    }

    protected void bindTopologyEventListener(TopologyEventListener eventListener) {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                this.pendingListeners.add(eventListener);
            } else {
                this.viewStateManager.bind(eventListener);
            }
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    protected void unbindTopologyEventListener(TopologyEventListener eventListener) {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                this.pendingListeners.remove(eventListener);
            } else {
                this.viewStateManager.unbind(eventListener);
            }
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("bindPropertyProvider: Binding PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.bindPropertyProviderInteral(propertyProvider, props);
        }
    }

    private void bindPropertyProviderInteral(PropertyProvider propertyProvider, Map<String, Object> props) {
        ProviderInfo info = new ProviderInfo(propertyProvider, props);
        this.providerInfos.add(info);
        Collections.sort(this.providerInfos);
        if (this.activated) {
            this.doUpdateProperties();
        }
        this.checkForTopologyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("bindPropertyProvider: Updating PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.unbindPropertyProviderInternal(propertyProvider, props, false);
            this.bindPropertyProviderInteral(propertyProvider, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("unbindPropertyProvider: Releasing PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.unbindPropertyProviderInternal(propertyProvider, props, true);
        }
    }

    private void unbindPropertyProviderInternal(PropertyProvider propertyProvider, Map<String, Object> props, boolean update) {
        ProviderInfo info = new ProviderInfo(propertyProvider, props);
        if (this.providerInfos.remove(info) && update) {
            if (this.activated) {
                this.doUpdateProperties();
            }
            this.checkForTopologyChange();
        }
    }

    private void doUpdateProperties() {
        ResourceResolverFactory rrf = this.resourceResolverFactory;
        Config c = this.config;
        String sid = this.slingId;
        if (rrf == null || c == null || sid == null) {
            logger.debug("doUpdateProperties: too early to update the properties. resourceResolverFactory ({}), config ({}) or slingId ({}) not yet set.", new Object[]{rrf, c, sid});
            return;
        }
        logger.debug("doUpdateProperties: updating properties now..");
        HashMap<String, String> newProps = new HashMap<String, String>();
        for (ProviderInfo info : this.providerInfos) {
            info.refreshProperties();
            newProps.putAll(info.properties);
        }
        try (ResourceResolver resourceResolver = null;){
            resourceResolver = rrf.getServiceResourceResolver(null);
            Resource myInstance = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)(c.getClusterInstancesPath() + "/" + sid + "/properties"));
            resourceResolver.revert();
            resourceResolver.refresh();
            ModifiableValueMap myInstanceMap = (ModifiableValueMap)myInstance.adaptTo(ModifiableValueMap.class);
            HashSet keys = new HashSet(myInstanceMap.keySet());
            for (String key : keys) {
                if (newProps.containsKey(key) || key.indexOf(":") != -1) continue;
                myInstanceMap.remove((Object)key);
            }
            boolean anyChanges = false;
            for (Map.Entry entry : newProps.entrySet()) {
                Object existingValue = myInstanceMap.get(entry.getKey());
                if (((String)entry.getValue()).equals(existingValue)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("doUpdateProperties: unchanged: {}={}", entry.getKey(), entry.getValue());
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("doUpdateProperties: changed: {}={}", entry.getKey(), entry.getValue());
                }
                anyChanges = true;
                myInstanceMap.put(entry.getKey(), entry.getValue());
            }
            if (anyChanges) {
                resourceResolver.commit();
            }
        }
        logger.debug("doUpdateProperties: updating properties done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.activated) {
                logger.debug("updateProperties: not yet activated, not calling doUpdateProperties this time.");
            } else {
                logger.debug("updateProperties: calling doUpdateProperties.");
                this.doUpdateProperties();
            }
            logger.debug("updateProperties: calling handlePotentialTopologyChange.");
            this.checkForTopologyChange();
            logger.debug("updateProperties: done.");
        }
    }

    public void checkForTopologyChange() {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                logger.debug("checkForTopologyChange: not yet activated, ignoring");
                return;
            }
            DefaultTopologyView t = (DefaultTopologyView)this.getTopology();
            if (t.isCurrent()) {
                this.viewStateManager.handleNewView((BaseTopologyView)t);
                this.setOldView(t);
            } else {
                this.viewStateManager.handleChanging();
            }
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    public void handleTopologyChanging() {
        logger.debug("handleTopologyChanging: invoking viewStateManager.handlechanging");
        this.viewStateManager.handleChanging();
    }

    protected ClusterViewService getClusterViewService() {
        return this.clusterViewService;
    }

    protected AnnouncementRegistry getAnnouncementRegistry() {
        return this.announcementRegistry;
    }

    public ViewStateManager getViewStateManager() {
        return this.viewStateManager;
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindOakViewChecker(OakViewChecker oakViewChecker) {
        this.oakViewChecker = oakViewChecker;
    }

    protected void unbindOakViewChecker(OakViewChecker oakViewChecker) {
        if (this.oakViewChecker == oakViewChecker) {
            this.oakViewChecker = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }

    protected void bindClusterViewService(ClusterViewService clusterViewService) {
        this.clusterViewService = clusterViewService;
    }

    protected void unbindClusterViewService(ClusterViewService clusterViewService) {
        if (this.clusterViewService == clusterViewService) {
            this.clusterViewService = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    protected void bindIdMapService(IdMapService idMapService) {
        this.idMapService = idMapService;
    }

    protected void unbindIdMapService(IdMapService idMapService) {
        if (this.idMapService == idMapService) {
            this.idMapService = null;
        }
    }

    protected void bindOakBacklogClusterSyncService(OakBacklogClusterSyncService oakBacklogClusterSyncService) {
        this.oakBacklogClusterSyncService = oakBacklogClusterSyncService;
    }

    protected void unbindOakBacklogClusterSyncService(OakBacklogClusterSyncService oakBacklogClusterSyncService) {
        if (this.oakBacklogClusterSyncService == oakBacklogClusterSyncService) {
            this.oakBacklogClusterSyncService = null;
        }
    }

    protected void bindSyncTokenService(SyncTokenService syncTokenService) {
        this.syncTokenService = syncTokenService;
    }

    protected void unbindSyncTokenService(SyncTokenService syncTokenService) {
        if (this.syncTokenService == syncTokenService) {
            this.syncTokenService = null;
        }
    }

    private static final class ProviderInfo
    implements Comparable<ProviderInfo> {
        public final PropertyProvider provider;
        public final Object propertyProperties;
        public final int ranking;
        public final long serviceId;
        public final Map<String, String> properties = new HashMap<String, String>();

        public ProviderInfo(PropertyProvider provider, Map<String, Object> serviceProps) {
            this.provider = provider;
            this.propertyProperties = serviceProps.get("instance.properties");
            Object sr = serviceProps.get("service.ranking");
            this.ranking = sr == null || !(sr instanceof Integer) ? 0 : (Integer)sr;
            this.serviceId = (Long)serviceProps.get("service.id");
            this.refreshProperties();
        }

        public void refreshProperties() {
            this.properties.clear();
            if (this.propertyProperties instanceof String) {
                String val = this.provider.getProperty((String)this.propertyProperties);
                if (val != null) {
                    this.putPropertyIfValid((String)this.propertyProperties, val);
                }
            } else if (this.propertyProperties instanceof String[]) {
                for (String name : (String[])this.propertyProperties) {
                    String val = this.provider.getProperty(name);
                    if (val == null) continue;
                    this.putPropertyIfValid(name, val);
                }
            }
        }

        private void putPropertyIfValid(String name, String val) {
            if (PropertyNameHelper.isValidPropertyName((String)name)) {
                this.properties.put(name, val);
            }
        }

        @Override
        public int compareTo(ProviderInfo o) {
            if (this.ranking < o.ranking) {
                return -1;
            }
            if (this.ranking > o.ranking) {
                return 1;
            }
            return this.serviceId < o.serviceId ? 1 : -1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProviderInfo) {
                return ((ProviderInfo)obj).serviceId == this.serviceId;
            }
            return false;
        }

        public int hashCode() {
            return this.provider.hashCode();
        }
    }
}

