/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak.pinger;

import java.util.Calendar;
import java.util.UUID;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.base.commons.BaseViewChecker;
import org.apache.sling.discovery.base.commons.PeriodicBackgroundJob;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.oak.Config;
import org.apache.sling.discovery.oak.OakDiscoveryService;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.http.HttpService;

@Component
@Service(value={OakViewChecker.class})
@Reference(referenceInterface=HttpService.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class OakViewChecker
extends BaseViewChecker {
    @Reference
    protected SlingSettingsService slingSettingsService;
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected ConnectorRegistry connectorRegistry;
    @Reference
    protected AnnouncementRegistry announcementRegistry;
    @Reference
    protected Scheduler scheduler;
    @Reference
    private Config config;
    private OakDiscoveryService discoveryService;
    protected PeriodicBackgroundJob periodicCheckViewJob;

    public static OakViewChecker testConstructor(SlingSettingsService slingSettingsService, ResourceResolverFactory resourceResolverFactory, ConnectorRegistry connectorRegistry, AnnouncementRegistry announcementRegistry, Scheduler scheduler, Config config) {
        OakViewChecker pinger = new OakViewChecker();
        pinger.slingSettingsService = slingSettingsService;
        pinger.resourceResolverFactory = resourceResolverFactory;
        pinger.connectorRegistry = connectorRegistry;
        pinger.announcementRegistry = announcementRegistry;
        pinger.scheduler = scheduler;
        pinger.config = config;
        return pinger;
    }

    protected AnnouncementRegistry getAnnouncementRegistry() {
        return this.announcementRegistry;
    }

    protected BaseConfig getConnectorConfig() {
        return this.config;
    }

    protected ConnectorRegistry getConnectorRegistry() {
        return this.connectorRegistry;
    }

    protected ResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    protected SlingSettingsService getSlingSettingsService() {
        return this.slingSettingsService;
    }

    protected void doActivate() {
        this.runtimeId = UUID.randomUUID().toString();
        this.logger.info("doActivate: activated with runtimeId: {}, slingId: {}", (Object)this.runtimeId, (Object)this.slingId);
        this.resetLeaderElectionId();
    }

    protected void deactivate() {
        super.deactivate();
        if (this.periodicCheckViewJob != null) {
            this.periodicCheckViewJob.stop();
            this.periodicCheckViewJob = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(OakDiscoveryService discoveryService) {
        this.logger.info("initialize: initializing.");
        Object object = this.lock;
        synchronized (object) {
            this.discoveryService = discoveryService;
            this.issueHeartbeat();
        }
        try {
            long interval = this.config.getConnectorPingInterval();
            this.logger.info("initialize: starting periodic connectorPing job for " + this.slingId + " with interval " + interval + " sec.");
            this.periodicPingJob = new PeriodicBackgroundJob(interval, this.NAME + ".connectorPinger", (Runnable)((Object)this));
        }
        catch (Exception e) {
            this.logger.error("activate: Could not start heartbeat runner: " + e, (Throwable)e);
        }
        try {
            long interval = this.config.getDiscoveryLiteCheckInterval();
            this.logger.info("initialize: starting periodic discoveryLiteCheck job for " + this.slingId + " with interval " + interval + " sec.");
            this.periodicCheckViewJob = new PeriodicBackgroundJob(interval, this.NAME + ".discoveryLiteCheck", new Runnable(){

                @Override
                public void run() {
                    OakViewChecker.this.discoveryLiteCheck();
                }
            });
        }
        catch (Exception e) {
            this.logger.error("activate: Could not start heartbeat runner: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoveryLiteCheck() {
        this.logger.debug("discoveryLiteCheck: start. [for slingId=" + this.slingId + "]");
        Object object = this.lock;
        synchronized (object) {
            if (!this.activated) {
                this.logger.debug("discoveryLiteCheck: not activated yet");
                return;
            }
            this.discoveryService.checkForTopologyChange();
        }
        this.logger.debug("discoveryLiteCheck: end. [for slingId=" + this.slingId + "]");
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        if (this.resourceResolverFactory == null) {
            this.logger.error("getResourceResolver: resourceResolverFactory is null!");
            return null;
        }
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    private String getLocalClusterNodePath() {
        return this.config.getClusterInstancesPath() + "/" + this.slingId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetLeaderElectionId() {
        try (ResourceResolver resourceResolver = null;){
            String myClusterNodePath = this.getLocalClusterNodePath();
            resourceResolver = this.getResourceResolver();
            if (resourceResolver == null) {
                this.logger.warn("resetLeaderElectionId: could not login, new leaderElectionId will be calculated upon next heartbeat only!");
                boolean bl = false;
                return bl;
            }
            String newLeaderElectionId = this.newLeaderElectionId();
            Resource resource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)myClusterNodePath);
            ModifiableValueMap resourceMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            resourceMap.put((Object)"runtimeId", (Object)this.runtimeId);
            String slingHomePath = "n/a";
            if (this.slingSettingsService != null && this.slingSettingsService.getSlingHomePath() != null) {
                slingHomePath = this.slingSettingsService.getSlingHomePath();
            }
            resourceMap.put((Object)"slingHomePath", (Object)slingHomePath);
            String endpointsAsString = this.getEndpointsAsString();
            resourceMap.put((Object)"endpoints", (Object)endpointsAsString);
            Calendar leaderElectionCreatedAt = Calendar.getInstance();
            resourceMap.put((Object)"leaderElectionId", (Object)newLeaderElectionId);
            resourceMap.put((Object)"leaderElectionIdCreatedAt", (Object)leaderElectionCreatedAt);
            this.logger.info("resetLeaderElectionId: storing my runtimeId: {}, endpoints: {}, sling home path: {}, new leaderElectionId: {}, created at: {}", new Object[]{this.runtimeId, endpointsAsString, slingHomePath, newLeaderElectionId, leaderElectionCreatedAt});
            resourceResolver.commit();
        }
        return true;
    }

    private String newLeaderElectionId() {
        int maxLongLength = String.valueOf(Long.MAX_VALUE).length();
        String currentTimeMillisStr = String.format("%0" + maxLongLength + "d", System.currentTimeMillis());
        String prefix = "1";
        String newLeaderElectionId = prefix + "_" + currentTimeMillisStr + "_" + this.slingId;
        return newLeaderElectionId;
    }

    protected void doCheckView() {
        super.doCheckView();
        this.discoveryService.checkForTopologyChange();
    }

    protected void updateProperties() {
        if (this.discoveryService != null) {
            this.discoveryService.updateProperties();
        }
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }
}

