/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%config.name", description="%config.description")
@Service(value={Config.class, BaseConfig.class, DiscoveryLiteConfig.class})
public class Config
implements BaseConfig,
DiscoveryLiteConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CLUSTERINSTANCES_RESOURCE = "clusterInstances";
    private static final String SYNC_TOKEN_RESOURCE = "syncTokens";
    private static final String ID_MAP_RESOURCE = "idMap";
    public static final long DEFAULT_TOPOLOGY_CONNECTOR_TIMEOUT = 120L;
    @Property(longValue={120L})
    public static final String TOPOLOGY_CONNECTOR_TIMEOUT_KEY = "connectorPingTimeout";
    protected long connectorPingTimeout = 120L;
    public static final long DEFAULT_TOPOLOGY_CONNECTOR_INTERVAL = 30L;
    @Property(longValue={30L})
    public static final String TOPOLOGY_CONNECTOR_INTERVAL_KEY = "connectorPingInterval";
    protected long connectorPingInterval = 30L;
    public static final long DEFAULT_DISCOVERY_LITE_CHECK_INTERVAL = 2L;
    @Property(longValue={2L})
    public static final String DISCOVERY_LITE_CHECK_INTERVAL_KEY = "discoveryLiteCheckInterval";
    protected long discoveryLiteCheckInterval = 2L;
    public static final long DEFAULT_CLUSTER_SYNC_SERVICE_TIMEOUT = 120L;
    @Property(longValue={120L})
    public static final String CLUSTER_SYNC_SERVICE_TIMEOUT_KEY = "clusterSyncServiceTimeout";
    protected long clusterSyncServiceTimeout = 120L;
    public static final long DEFAULT_CLUSTER_SYNC_SERVICE_INTERVAL = 2L;
    @Property(longValue={2L})
    public static final String CLUSTER_SYNC_SERVICE_INTERVAL_KEY = "clusterSyncServiceInterval";
    protected long clusterSyncServiceInterval = 2L;
    @Property(boolValue={true})
    private static final String SYNC_TOKEN_ENABLED = "enableSyncToken";
    public static final int DEFAULT_MIN_EVENT_DELAY = 3;
    @Property(intValue={3})
    public static final String MIN_EVENT_DELAY_KEY = "minEventDelay";
    protected int minEventDelay = 3;
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT = 10;
    @Property(intValue={10})
    public static final String SOCKET_CONNECT_TIMEOUT_KEY = "socketConnectTimeout";
    private int socketConnectTimeout = 10;
    public static final int DEFAULT_SO_TIMEOUT = 10;
    @Property(intValue={10})
    public static final String SO_TIMEOUT_KEY = "soTimeout";
    private int soTimeout = 10;
    @Property(cardinality=1024)
    public static final String TOPOLOGY_CONNECTOR_URLS_KEY = "topologyConnectorUrls";
    private URL[] topologyConnectorUrls = new URL[]{null};
    private static final String[] DEFAULT_TOPOLOGY_CONNECTOR_WHITELIST = new String[]{"localhost", "127.0.0.1"};
    @Property(value={"localhost", "127.0.0.1"})
    public static final String TOPOLOGY_CONNECTOR_WHITELIST_KEY = "topologyConnectorWhitelist";
    protected String[] topologyConnectorWhitelist = DEFAULT_TOPOLOGY_CONNECTOR_WHITELIST;
    private static final String DEFAULT_DISCOVERY_RESOURCE_PATH = "/var/discovery/oak/";
    @Property(value={"/var/discovery/oak/"}, propertyPrivate=true)
    public static final String DISCOVERY_RESOURCE_PATH_KEY = "discoveryResourcePath";
    protected String discoveryResourcePath = "/var/discovery/oak/";
    @Property(boolValue={false})
    private static final String AUTO_STOP_LOCAL_LOOP_ENABLED = "autoStopLocalLoopEnabled";
    @Property(boolValue={false})
    private static final String GZIP_CONNECTOR_REQUESTS_ENABLED = "gzipConnectorRequestsEnabled";
    @Property(boolValue={false})
    private static final String HMAC_ENABLED = "hmacEnabled";
    @Property(boolValue={false})
    private static final String ENCRYPTION_ENABLED = "enableEncryption";
    @Property
    private static final String SHARED_KEY = "sharedKey";
    private static final long DEFAULT_SHARED_KEY_INTERVAL = 14400000L;
    @Property(longValue={14400000L})
    private static final String SHARED_KEY_INTERVAL = "hmacSharedKeyTTL";
    @Property
    private static final String BACKOFF_STANDBY_FACTOR = "backoffStandbyFactor";
    private static final int DEFAULT_BACKOFF_STANDBY_FACTOR = 5;
    @Property
    private static final String BACKOFF_STABLE_FACTOR = "backoffStableFactor";
    private static final int DEFAULT_BACKOFF_STABLE_FACTOR = 5;
    private boolean autoStopLocalLoopEnabled;
    private boolean hmacEnabled;
    private String sharedKey;
    private long keyInterval;
    private boolean encryptionEnabled;
    private boolean gzipConnectorRequestsEnabled;
    private int backoffStandbyFactor = 5;
    private int backoffStableFactor = 5;
    private boolean syncTokenEnabled;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.logger.debug("activate: config activated.");
        this.configure(properties);
    }

    protected void configure(Map<String, Object> properties) {
        this.connectorPingTimeout = PropertiesUtil.toLong((Object)properties.get(TOPOLOGY_CONNECTOR_TIMEOUT_KEY), (long)120L);
        this.logger.debug("configure: connectorPingTimeout='{}'", (Object)this.connectorPingTimeout);
        this.connectorPingInterval = PropertiesUtil.toLong((Object)properties.get(TOPOLOGY_CONNECTOR_INTERVAL_KEY), (long)30L);
        this.logger.debug("configure: connectorPingInterval='{}'", (Object)this.connectorPingInterval);
        this.discoveryLiteCheckInterval = PropertiesUtil.toLong((Object)properties.get(DISCOVERY_LITE_CHECK_INTERVAL_KEY), (long)2L);
        this.logger.debug("configure: discoveryLiteCheckInterval='{}'", (Object)this.discoveryLiteCheckInterval);
        this.clusterSyncServiceTimeout = PropertiesUtil.toLong((Object)properties.get(CLUSTER_SYNC_SERVICE_TIMEOUT_KEY), (long)120L);
        this.logger.debug("configure: clusterSyncServiceTimeout='{}'", (Object)this.clusterSyncServiceTimeout);
        this.clusterSyncServiceInterval = PropertiesUtil.toLong((Object)properties.get(CLUSTER_SYNC_SERVICE_INTERVAL_KEY), (long)120L);
        this.logger.debug("configure: clusterSyncServiceInterval='{}'", (Object)this.clusterSyncServiceInterval);
        this.minEventDelay = PropertiesUtil.toInteger((Object)properties.get(MIN_EVENT_DELAY_KEY), (int)3);
        this.logger.debug("configure: minEventDelay='{}'", (Object)this.minEventDelay);
        this.socketConnectTimeout = PropertiesUtil.toInteger((Object)properties.get(SOCKET_CONNECT_TIMEOUT_KEY), (int)10);
        this.logger.debug("configure: socketConnectTimeout='{}'", (Object)this.socketConnectTimeout);
        this.soTimeout = PropertiesUtil.toInteger((Object)properties.get(SO_TIMEOUT_KEY), (int)10);
        this.logger.debug("configure: soTimeout='{}'", (Object)this.soTimeout);
        String[] topologyConnectorUrlsStr = PropertiesUtil.toStringArray((Object)properties.get(TOPOLOGY_CONNECTOR_URLS_KEY), null);
        if (topologyConnectorUrlsStr != null && topologyConnectorUrlsStr.length > 0) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (int i = 0; i < topologyConnectorUrlsStr.length; ++i) {
                String anUrlStr = topologyConnectorUrlsStr[i];
                try {
                    if (anUrlStr == null || anUrlStr.length() <= 0) continue;
                    URL url = new URL(anUrlStr);
                    this.logger.debug("configure: a topologyConnectorbUrl='{}'", (Object)url);
                    urls.add(url);
                    continue;
                }
                catch (MalformedURLException e) {
                    this.logger.error("configure: could not set a topologyConnectorUrl: " + e, (Throwable)e);
                }
            }
            if (urls.size() > 0) {
                this.topologyConnectorUrls = urls.toArray(new URL[urls.size()]);
                this.logger.debug("configure: number of topologyConnectorUrls='{}''", (Object)urls.size());
            } else {
                this.topologyConnectorUrls = null;
                this.logger.debug("configure: no (valid) topologyConnectorUrls configured");
            }
        } else {
            this.topologyConnectorUrls = null;
            this.logger.debug("configure: no (valid) topologyConnectorUrls configured");
        }
        this.topologyConnectorWhitelist = PropertiesUtil.toStringArray((Object)properties.get(TOPOLOGY_CONNECTOR_WHITELIST_KEY), (String[])DEFAULT_TOPOLOGY_CONNECTOR_WHITELIST);
        this.logger.debug("configure: topologyConnectorWhitelist='{}'", (Object[])this.topologyConnectorWhitelist);
        this.discoveryResourcePath = PropertiesUtil.toString((Object)properties.get(DISCOVERY_RESOURCE_PATH_KEY), (String)"");
        while (this.discoveryResourcePath.endsWith("/")) {
            this.discoveryResourcePath = this.discoveryResourcePath.substring(0, this.discoveryResourcePath.length() - 1);
        }
        this.discoveryResourcePath = this.discoveryResourcePath + "/";
        if (this.discoveryResourcePath == null || this.discoveryResourcePath.length() <= 1) {
            this.discoveryResourcePath = DEFAULT_DISCOVERY_RESOURCE_PATH;
        }
        this.logger.debug("configure: discoveryResourcePath='{}'", (Object)this.discoveryResourcePath);
        this.autoStopLocalLoopEnabled = PropertiesUtil.toBoolean((Object)properties.get(AUTO_STOP_LOCAL_LOOP_ENABLED), (boolean)false);
        this.gzipConnectorRequestsEnabled = PropertiesUtil.toBoolean((Object)properties.get(GZIP_CONNECTOR_REQUESTS_ENABLED), (boolean)false);
        this.hmacEnabled = PropertiesUtil.toBoolean((Object)properties.get(HMAC_ENABLED), (boolean)true);
        this.encryptionEnabled = PropertiesUtil.toBoolean((Object)properties.get(ENCRYPTION_ENABLED), (boolean)false);
        this.syncTokenEnabled = PropertiesUtil.toBoolean((Object)properties.get(SYNC_TOKEN_ENABLED), (boolean)true);
        this.sharedKey = PropertiesUtil.toString((Object)properties.get(SHARED_KEY), null);
        this.keyInterval = PropertiesUtil.toLong((Object)SHARED_KEY_INTERVAL, (long)14400000L);
        this.backoffStandbyFactor = PropertiesUtil.toInteger((Object)properties.get(BACKOFF_STANDBY_FACTOR), (int)5);
        this.backoffStableFactor = PropertiesUtil.toInteger((Object)properties.get(BACKOFF_STABLE_FACTOR), (int)5);
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getMinEventDelay() {
        return this.minEventDelay;
    }

    public URL[] getTopologyConnectorURLs() {
        return this.topologyConnectorUrls;
    }

    public String[] getTopologyConnectorWhitelist() {
        return this.topologyConnectorWhitelist;
    }

    protected String getDiscoveryResourcePath() {
        return this.discoveryResourcePath;
    }

    public String getClusterInstancesPath() {
        return this.getDiscoveryResourcePath() + CLUSTERINSTANCES_RESOURCE;
    }

    public String getSyncTokenPath() {
        return this.getDiscoveryResourcePath() + SYNC_TOKEN_RESOURCE;
    }

    public String getIdMapPath() {
        return this.getDiscoveryResourcePath() + ID_MAP_RESOURCE;
    }

    public boolean isHmacEnabled() {
        return this.hmacEnabled;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public long getKeyInterval() {
        return this.keyInterval;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public boolean isGzipConnectorRequestsEnabled() {
        return this.gzipConnectorRequestsEnabled;
    }

    public boolean isAutoStopLocalLoopEnabled() {
        return this.autoStopLocalLoopEnabled;
    }

    public int getBackoffStandbyFactor() {
        return this.backoffStandbyFactor;
    }

    public int getBackoffStableFactor() {
        return this.backoffStableFactor;
    }

    public long getBackoffStandbyInterval() {
        int factor = this.getBackoffStandbyFactor();
        if (factor <= 1) {
            return -1L;
        }
        return (long)factor * this.getConnectorPingInterval();
    }

    public long getConnectorPingInterval() {
        return this.connectorPingInterval;
    }

    public long getConnectorPingTimeout() {
        return this.connectorPingTimeout;
    }

    public long getDiscoveryLiteCheckInterval() {
        return this.discoveryLiteCheckInterval;
    }

    public long getClusterSyncServiceTimeoutMillis() {
        return this.clusterSyncServiceTimeout * 1000L;
    }

    public long getClusterSyncServiceIntervalMillis() {
        return this.clusterSyncServiceInterval * 1000L;
    }

    public boolean getSyncTokenEnabled() {
        return this.syncTokenEnabled;
    }
}

