/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.EventHelper;
import org.apache.sling.discovery.commons.providers.ViewStateManager;
import org.apache.sling.discovery.commons.providers.base.AsyncEvent;
import org.apache.sling.discovery.commons.providers.base.AsyncEventSender;
import org.apache.sling.discovery.commons.providers.base.MinEventDelayHandler;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.discovery.commons.providers.util.LogSilencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewStateManagerImpl
implements ViewStateManager {
    private static final Logger logger = LoggerFactory.getLogger(ViewStateManagerImpl.class);
    private List<TopologyEventListener> eventListeners = new ArrayList<TopologyEventListener>();
    private List<TopologyEventListener> unInitializedEventListeners = new ArrayList<TopologyEventListener>();
    private boolean activated;
    private BaseTopologyView previousView;
    private boolean isChanging;
    protected final Lock lock;
    private final ClusterSyncService consistencyService;
    private int modCnt = 0;
    private AsyncEventSender asyncEventSender;
    private Map<TopologyEventListener, TopologyEvent.Type> lastEventMap = new HashMap<TopologyEventListener, TopologyEvent.Type>();
    private MinEventDelayHandler minEventDelayHandler;
    private final LogSilencer logSilencer = new LogSilencer(logger);

    ViewStateManagerImpl(Lock lock, ClusterSyncService consistencyService) {
        if (lock == null) {
            throw new IllegalArgumentException("lock must not be null");
        }
        this.lock = lock;
        this.consistencyService = consistencyService;
    }

    @Override
    public void installMinEventDelayHandler(DiscoveryService discoveryService, Scheduler scheduler, long minEventDelaySecs) {
        this.minEventDelayHandler = new MinEventDelayHandler(this, this.lock, discoveryService, scheduler, minEventDelaySecs);
    }

    protected boolean hadPreviousView() {
        return this.previousView != null;
    }

    protected boolean unchanged(BaseTopologyView newView) {
        if (this.isChanging) {
            return false;
        }
        if (this.previousView == null) {
            return false;
        }
        return this.previousView.equals(newView);
    }

    @Override
    public void bind(TopologyEventListener eventListener) {
        logger.trace("bind: start {}", (Object)eventListener);
        this.lock.lock();
        try {
            logger.debug("bind: Binding TopologyEventListener {}", (Object)eventListener);
            if (this.eventListeners.contains(eventListener) || this.unInitializedEventListeners.contains(eventListener)) {
                logger.info("bind: TopologyEventListener already registered: " + eventListener);
                return;
            }
            if (this.activated) {
                if (this.isChanging || this.previousView == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("bind: view is not yet/currently not defined (isChanging: " + this.isChanging + ", previousView==null: " + (this.previousView == null) + ", delaying INIT to " + eventListener);
                    }
                    this.unInitializedEventListeners.add(eventListener);
                } else {
                    logger.debug("bind: view is defined, sending INIT now to {}", (Object)eventListener);
                    this.enqueue(eventListener, EventHelper.newInitEvent(this.previousView), true);
                    this.eventListeners.add(eventListener);
                }
            } else {
                logger.debug("bind: not yet activated, delaying INIT to {}", (Object)eventListener);
                this.unInitializedEventListeners.add(eventListener);
            }
        }
        finally {
            this.lock.unlock();
            logger.trace("bind: end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unbind(TopologyEventListener eventListener) {
        logger.trace("unbind: start {}", (Object)eventListener);
        this.lock.lock();
        try {
            logger.debug("unbind: Releasing TopologyEventListener {}", (Object)eventListener);
            boolean a = this.eventListeners.remove(eventListener);
            boolean b = this.unInitializedEventListeners.remove(eventListener);
            boolean bl = a || b;
            return bl;
        }
        finally {
            this.lock.unlock();
            logger.trace("unbind: end");
        }
    }

    private void enqueue(TopologyEventListener da, TopologyEvent event, boolean logInfo) {
        logger.trace("enqueue: start: topologyEvent {}, to {}", (Object)event, (Object)da);
        if (this.asyncEventSender == null) {
            logger.warn("enqueue: asyncEventSender is null, cannot send event ({}, {})!", (Object)da, (Object)event);
            return;
        }
        if (this.lastEventMap.get(da) == event.getType() && event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            if (logInfo) {
                logger.info("enqueue: listener already got TOPOLOGY_CHANGING: {}", (Object)da);
            } else {
                logger.debug("enqueue: listener already got TOPOLOGY_CHANGING: {}", (Object)da);
            }
            return;
        }
        if (logInfo) {
            logger.info("enqueue: enqueuing topologyEvent {}, to {}", (Object)EventHelper.toShortString(event), (Object)da);
        } else {
            logger.debug("enqueue: enqueuing topologyEvent {}, to {}", (Object)event, (Object)da);
        }
        this.asyncEventSender.enqueue(da, event);
        this.lastEventMap.put(da, event.getType());
        logger.trace("enqueue: sending topologyEvent {}, to {}", (Object)event, (Object)da);
    }

    private void enqueueForAll(List<TopologyEventListener> audience, TopologyEvent event) {
        logger.info("enqueueForAll: sending topologyEvent {}, to all ({}) listeners", (Object)EventHelper.toShortString(event), (Object)audience.size());
        for (TopologyEventListener topologyEventListener : audience) {
            this.enqueue(topologyEventListener, event, false);
        }
        logger.trace("enqueueForAll: sent topologyEvent {}, to all ({}) listeners", (Object)event, (Object)audience.size());
    }

    @Override
    public void handleActivated() {
        logger.trace("handleActivated: start");
        this.lock.lock();
        try {
            logger.debug("handleActivated: activating the ViewStateManager");
            this.activated = true;
            ++this.modCnt;
            this.asyncEventSender = new AsyncEventSender();
            Thread th = new Thread(this.asyncEventSender);
            th.setName("Discovery-AsyncEventSender");
            th.setDaemon(true);
            th.start();
            if (this.previousView != null && !this.isChanging) {
                this.enqueueForAll(this.unInitializedEventListeners, EventHelper.newInitEvent(this.previousView));
                this.eventListeners.addAll(this.unInitializedEventListeners);
                this.unInitializedEventListeners.clear();
            }
            logger.debug("handleActivated: activated the ViewStateManager");
        }
        finally {
            this.lock.unlock();
            logger.trace("handleActivated: finally");
        }
    }

    @Override
    public void handleDeactivated() {
        logger.trace("handleDeactivated: start");
        this.lock.lock();
        try {
            logger.debug("handleDeactivated: deactivating the ViewStateManager");
            this.activated = false;
            ++this.modCnt;
            if (this.asyncEventSender != null) {
                this.asyncEventSender.flushThenStop();
                this.asyncEventSender = null;
            }
            if (this.previousView != null) {
                this.previousView.setNotCurrent();
                logger.trace("handleDeactivated: setting previousView to null");
                this.previousView = null;
            }
            if (this.consistencyService != null) {
                this.consistencyService.cancelSync();
            }
            if (this.minEventDelayHandler != null) {
                this.minEventDelayHandler.cancelDelaying();
            }
            logger.trace("handleDeactivated: setting isChanging to false");
            this.isChanging = false;
            this.eventListeners.clear();
            this.unInitializedEventListeners.clear();
            logger.debug("handleDeactivated: deactivated the ViewStateManager");
        }
        finally {
            this.lock.unlock();
            logger.trace("handleDeactivated: finally");
        }
    }

    @Override
    public void handleChanging() {
        logger.trace("handleChanging: start");
        this.lock.lock();
        try {
            if (this.isChanging) {
                logger.debug("handleChanging: was already changing - ignoring.");
                return;
            }
            ++this.modCnt;
            logger.trace("handleChanging: setting isChanging to true");
            this.isChanging = true;
            if (!this.activated) {
                logger.debug("handleChanging: not yet activated - ignoring.");
                return;
            }
            if (this.previousView == null) {
                logger.debug("handleChanging: no previousView set - ignoring.");
                return;
            }
            logger.debug("handleChanging: sending TOPOLOGY_CHANGING to initialized listeners");
            this.previousView.setNotCurrent();
            this.enqueueForAll(this.eventListeners, EventHelper.newChangingEvent(this.previousView));
        }
        finally {
            this.lock.unlock();
            logger.trace("handleChanging: finally");
        }
    }

    @Override
    public void handleNewView(BaseTopologyView newView) {
        logger.trace("handleNewView: start, newView={}", (Object)newView);
        if (newView == null) {
            throw new IllegalArgumentException("newView must not be null");
        }
        if (!newView.isCurrent()) {
            logger.debug("handleNewView: newView is not current - calling handleChanging.");
            this.handleChanging();
            return;
        }
        InstanceDescription localInstance = newView.getLocalInstance();
        if (localInstance == null) {
            throw new IllegalStateException("newView does not contain the local instance - hence cannot be current");
        }
        if (!localInstance.isLocal()) {
            throw new IllegalStateException("newView's local instance is not isLocal - very unexpected - hence cannot be current");
        }
        if (this.consistencyService != null) {
            this.consistencyService.cancelSync();
        }
        logger.debug("handleNewView: newView is current, so trying with minEventDelayHandler...");
        if (this.minEventDelayHandler != null) {
            if (this.minEventDelayHandler.handlesNewView(newView)) {
                return;
            }
            logger.debug("handleNewView: event delaying not applicable this time, invoking hanldeNewViewNonDelayed next.");
        } else {
            logger.debug("handleNewView: minEventDelayHandler not set, invoking hanldeNewViewNonDelayed...");
        }
        this.handleNewViewNonDelayed(newView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleNewViewNonDelayed(final BaseTopologyView newView) {
        logger.trace("handleNewViewNonDelayed: start");
        this.lock.lock();
        try {
            boolean invokeClusterSyncService;
            logger.debug("handleNewViewNonDelayed: start, newView={}", (Object)newView);
            if (!newView.isCurrent()) {
                logger.error("handleNewViewNonDelayed: newView must be current");
                throw new IllegalArgumentException("newView must be current");
            }
            ++this.modCnt;
            if (!this.isChanging) {
                if (this.previousView != null && (this.previousView.equals(newView) || this.equalsIgnoreSyncToken(newView))) {
                    logger.debug("handleNewViewNonDelayed: we were not in changing state and new view matches old, so - ignoring");
                    boolean bl = false;
                    return bl;
                }
                if (this.previousView == null || !this.onlyDiffersInProperties(newView)) {
                    logger.debug("handleNewViewNonDelayed: implicitly triggering a handleChanging as we were not in changing state");
                    this.handleChanging();
                    logger.debug("handleNewViewNonDelayed: implicitly triggering of a handleChanging done");
                }
            }
            if (!this.activated) {
                logger.trace("handleNewViewNonDelayed: setting previousView to {}", (Object)newView);
                this.previousView = newView;
                logger.trace("handleNewViewNonDelayed: setting isChanging to false");
                this.isChanging = false;
                logger.debug("handleNewViewNonDelayed: not yet activated - ignoring");
                boolean bl = true;
                return bl;
            }
            if (!this.isChanging && this.onlyDiffersInProperties(newView)) {
                this.logSilencer.infoOrDebug("handleNewViewNonDelayed-propsChanged", "handleNewViewNonDelayed: properties changed to: " + newView);
                this.previousView.setNotCurrent();
                this.enqueueForAll(this.eventListeners, EventHelper.newPropertiesChangedEvent(this.previousView, newView));
                logger.trace("handleNewViewNonDelayed: setting previousView to {}", (Object)newView);
                this.previousView = newView;
                boolean bl = true;
                return bl;
            }
            if (this.consistencyService == null) {
                this.logSilencer.infoOrDebug("handleNewViewNonDelayed-noSyncService", "handleNewViewNonDelayed: no ClusterSyncService set - continuing directly.");
                invokeClusterSyncService = false;
            } else {
                this.logSilencer.infoOrDebug("handleNewViewNonDelayed-invokeSyncService", "handleNewViewNonDelayed: ClusterSyncService set - invoking...");
                invokeClusterSyncService = true;
            }
            if (invokeClusterSyncService) {
                final int lastModCnt = this.modCnt;
                this.logSilencer.infoOrDebug("handleNewViewNonDelayed-invokeWaitAsync", "handleNewViewNonDelayed: invoking waitForAsyncEvents, then clusterSyncService");
                this.asyncEventSender.enqueue(new AsyncEvent(){

                    public String toString() {
                        return "the waitForAsyncEvents-flush-token-" + this.hashCode();
                    }

                    @Override
                    public void trigger() {
                        ViewStateManagerImpl.this.lock.lock();
                        try {
                            if (ViewStateManagerImpl.this.modCnt != lastModCnt) {
                                logger.info("handleNewViewNonDelayed/waitForAsyncEvents.run: modCnt changed (from {} to {}) - ignoring", (Object)lastModCnt, (Object)ViewStateManagerImpl.this.modCnt);
                                return;
                            }
                            ViewStateManagerImpl.this.logSilencer.infoOrDebug("waitForAsyncEvents-asyncRun", "handleNewViewNonDelayed/waitForAsyncEvents.run: done, now invoking consistencyService");
                            ViewStateManagerImpl.this.consistencyService.sync(newView, new Runnable(){

                                @Override
                                public void run() {
                                    logger.trace("consistencyService.callback.run: start. acquiring lock...");
                                    ViewStateManagerImpl.this.lock.lock();
                                    try {
                                        logger.debug("consistencyService.callback.run: lock aquired. (modCnt should be {}, is {})", (Object)lastModCnt, (Object)ViewStateManagerImpl.this.modCnt);
                                        if (ViewStateManagerImpl.this.modCnt != lastModCnt) {
                                            logger.info("consistencyService.callback.run: modCnt changed (from {} to {}) - ignoring", (Object)lastModCnt, (Object)ViewStateManagerImpl.this.modCnt);
                                            return;
                                        }
                                        ViewStateManagerImpl.this.logSilencer.infoOrDebug("consistencyService-callBackRun", "consistencyService.callback.run: invoking doHandleConsistent.");
                                        ViewStateManagerImpl.this.doHandleConsistent(newView);
                                    }
                                    finally {
                                        ViewStateManagerImpl.this.lock.unlock();
                                        logger.trace("consistencyService.callback.run: end.");
                                    }
                                }
                            });
                        }
                        finally {
                            ViewStateManagerImpl.this.lock.unlock();
                        }
                    }
                });
            } else {
                this.logSilencer.infoOrDebug("handleNewViewNonDelayed-noSyncService-ignore", "handleNewViewNonDelayed: not invoking consistencyService, considering consistent now");
                this.doHandleConsistent(newView);
            }
            logger.debug("handleNewViewNonDelayed: end");
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
            logger.trace("handleNewViewNonDelayed: finally");
        }
    }

    protected boolean equalsIgnoreSyncToken(BaseTopologyView newView) {
        LocalClusterView local;
        if (this.previousView == null) {
            return false;
        }
        if (newView == null) {
            throw new IllegalArgumentException("newView must not be null");
        }
        ClusterView cluster = newView.getLocalInstance().getClusterView();
        if (cluster instanceof LocalClusterView && !(local = (LocalClusterView)cluster).hasPartiallyStartedInstances()) {
            return this.previousView.equals(newView);
        }
        return this.previousView.getInstances().equals(newView.getInstances());
    }

    protected boolean onlyDiffersInProperties(BaseTopologyView newView) {
        if (this.previousView == null) {
            return false;
        }
        if (newView == null) {
            throw new IllegalArgumentException("newView must not be null");
        }
        String previousSyncTokenId = null;
        String newSyncTokenId = null;
        try {
            previousSyncTokenId = this.previousView.getLocalClusterSyncTokenId();
        }
        catch (IllegalStateException re) {
            previousSyncTokenId = null;
        }
        try {
            newSyncTokenId = newView.getLocalClusterSyncTokenId();
        }
        catch (IllegalStateException re) {
            newSyncTokenId = null;
        }
        if (previousSyncTokenId == null && newSyncTokenId != null || newSyncTokenId == null && previousSyncTokenId != null || previousSyncTokenId != null && !previousSyncTokenId.equals(newSyncTokenId)) {
            return false;
        }
        if (this.previousView.getInstances().size() != newView.getInstances().size()) {
            return false;
        }
        if (this.previousView.equals(newView)) {
            return false;
        }
        HashSet<String> newIds = new HashSet<String>();
        for (InstanceDescription newInstance : newView.getInstances()) {
            newIds.add(newInstance.getSlingId());
        }
        for (InstanceDescription oldInstance : this.previousView.getInstances()) {
            InstanceDescription newInstance = newView.getInstance(oldInstance.getSlingId());
            if (newInstance == null) {
                return false;
            }
            if (oldInstance.isLeader() != newInstance.isLeader()) {
                return false;
            }
            if (oldInstance.getClusterView().getId().equals(newInstance.getClusterView().getId())) continue;
            return false;
        }
        return true;
    }

    private void doHandleConsistent(BaseTopologyView newView) {
        logger.trace("doHandleConsistent: start");
        logger.trace("doHandleConsistent: setting isChanging to false");
        this.isChanging = false;
        if (this.previousView == null) {
            if (this.eventListeners.size() > 0) {
                logger.info("doHandleConsistent: no previous view available even though listeners already got CHANGED event");
            } else {
                logger.debug("doHandleConsistent: no previous view and there are no event listeners yet. very quiet.");
            }
        } else {
            logger.debug("doHandleConsistent: sending TOPOLOGY_CHANGED to initialized listeners");
            this.previousView.setNotCurrent();
            this.enqueueForAll(this.eventListeners, EventHelper.newChangedEvent(this.previousView, newView));
        }
        if (this.unInitializedEventListeners.size() > 0) {
            logger.debug("doHandleConsistent: sending TOPOLOGY_INIT to uninitialized listeners ({})", (Object)this.unInitializedEventListeners.size());
            this.enqueueForAll(this.unInitializedEventListeners, EventHelper.newInitEvent(newView));
            this.eventListeners.addAll(this.unInitializedEventListeners);
            this.unInitializedEventListeners.clear();
        }
        logger.trace("doHandleConsistent: setting previousView to {}", (Object)newView);
        this.previousView = newView;
        logger.trace("doHandleConsistent: end");
    }

    AsyncEventSender getAsyncEventSender() {
        return this.asyncEventSender;
    }

    @Override
    public int waitForAsyncEvents(long timeout) {
        int inFlightEventCnt;
        long end = System.currentTimeMillis() + timeout;
        while (true) {
            if ((inFlightEventCnt = this.getInFlightAsyncEventCnt()) == 0) {
                return 0;
            }
            if (timeout == 0L) {
                return inFlightEventCnt;
            }
            if (timeout >= 0L && System.currentTimeMillis() >= end) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return inFlightEventCnt;
    }

    private int getInFlightAsyncEventCnt() {
        int cnt = this.asyncEventSender.getInFlightEventCnt();
        if (this.minEventDelayHandler != null && this.minEventDelayHandler.isDelaying()) {
            ++cnt;
        }
        return cnt;
    }
}

