/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.NamingException;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.jcr.repository.RepositoryImpl;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.commit.JcrConflictHandler;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.InitialContent;
import org.apache.jackrabbit.oak.plugins.version.VersionEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.OpenSecurityProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.DefaultWhiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.testing.jcr.RepositoryProvider;
import org.apache.sling.commons.testing.jcr.RepositoryUtil;
import org.apache.sling.discovery.commons.providers.spi.base.MockedResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.hamcrest.Description;
import org.jmock.Expectations;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.api.ThreadingPolicy;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.concurrent.Synchroniser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryTestHelper {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryTestHelper.class);
    static Map<SlingRepository, Session> adminSessions = new HashMap<SlingRepository, Session>();
    public static final String CONFIG_FILE = "jackrabbit-test-config.xml";

    public static void dumpRepo(ResourceResolverFactory resourceResolverFactory) throws Exception {
        Session session = (Session)resourceResolverFactory.getServiceResourceResolver(null).adaptTo(Session.class);
        logger.info("dumpRepo: ====== START =====");
        logger.info("dumpRepo: repo = " + session.getRepository());
        RepositoryTestHelper.dump(session.getRootNode());
        logger.info("dumpRepo: ======  END  =====");
        session.logout();
    }

    public static void dump(Node node) throws RepositoryException {
        if (node.getPath().equals("/jcr:system") || node.getPath().equals("/rep:policy")) {
            return;
        }
        PropertyIterator pi = node.getProperties();
        StringBuilder sb = new StringBuilder();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            sb.append(" ");
            sb.append(p.getName());
            sb.append("=");
            if (p.getType() == 6) {
                sb.append(p.getBoolean());
                continue;
            }
            if (p.getType() == 1) {
                sb.append(p.getString());
                continue;
            }
            if (p.getType() == 5) {
                sb.append(p.getDate().getTime());
                continue;
            }
            if (p.getType() == 3) {
                sb.append(p.getLong());
                continue;
            }
            sb.append("<unknown type=" + p.getType() + "/>");
        }
        StringBuffer depth = new StringBuffer();
        for (int i = 0; i < node.getDepth(); ++i) {
            depth.append(" ");
        }
        logger.info(depth + "/" + node.getName() + " -- " + sb);
        NodeIterator it = node.getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            RepositoryTestHelper.dump(child);
        }
    }

    public static SlingRepository newOakRepository(NodeStore nodeStore) throws RepositoryException {
        RepositoryUtil.RepositoryWrapper repository = new RepositoryUtil.RepositoryWrapper(RepositoryTestHelper.createOakRepository(nodeStore));
        return repository;
    }

    public static void initSlingNodeTypes(SlingRepository repository) throws RepositoryException {
        Session adminSession = null;
        try {
            adminSession = repository.loginAdministrative(null);
            RepositoryUtil.registerSlingNodeTypes((Session)adminSession);
        }
        catch (IOException ioe) {
            throw new RepositoryException((Throwable)ioe);
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    public static void stopRepository(SlingRepository repository) throws NamingException {
        Session adminSession = adminSessions.remove(repository);
        if (adminSession != null) {
            adminSession.logout();
        }
    }

    public static Repository createOakRepository() {
        return RepositoryTestHelper.createOakRepository((NodeStore)new MemoryNodeStore());
    }

    public static Repository createOakRepository(NodeStore nodeStore) {
        DefaultWhiteboard whiteboard = new DefaultWhiteboard();
        Oak oak = new Oak(nodeStore).with((RepositoryInitializer)new InitialContent()).with((ConflictHandler)JcrConflictHandler.createJcrConflictHandler()).with((CommitHook)new EditorHook((EditorProvider)new VersionEditorProvider())).with((SecurityProvider)new OpenSecurityProvider()).with((EditorProvider)new NamespaceEditorProvider()).with((EditorProvider)new TypeEditorProvider()).with((EditorProvider)new ConflictValidatorProvider()).with("default").with((Whiteboard)whiteboard);
        ContentRepository contentRepository = oak.createContentRepository();
        return new RepositoryImpl(contentRepository, (Whiteboard)whiteboard, (SecurityProvider)new OpenSecurityProvider(), 1000, null);
    }

    public static void resetRepo() throws Exception {
        Session l = RepositoryProvider.instance().getRepository().loginAdministrative(null);
        try {
            l.removeItem("/var");
            l.save();
            l.logout();
        }
        catch (Exception e) {
            l.refresh(false);
            l.logout();
        }
    }

    public static ResourceResolverFactory mockResourceResolverFactory(final SlingRepository repositoryOrNull) throws Exception {
        JUnit4Mockery context = new JUnit4Mockery(){
            {
                this.setThreadingPolicy((ThreadingPolicy)new Synchroniser());
            }
        };
        final ResourceResolverFactory resourceResolverFactory = (ResourceResolverFactory)context.mock(ResourceResolverFactory.class);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResourceResolverFactory)this.allowing(resourceResolverFactory)).getServiceResourceResolver(null);
                this.will(new Action(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        return new MockedResourceResolver(repositoryOrNull);
                    }

                    public void describeTo(Description arg0) {
                        arg0.appendText("whateva - im going to create a new mockedresourceresolver");
                    }
                });
            }
        });
        return resourceResolverFactory;
    }
}

