/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.base.DummyListener;
import org.apache.sling.discovery.commons.providers.base.TestHelper;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerImpl;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ViewStateManagerImpl> mgrList;
    private Random defaultRandom;

    @Before
    public void setup() throws Exception {
        this.mgrList = new LinkedList<ViewStateManagerImpl>();
        this.defaultRandom = new Random(1234123412L);
    }

    @After
    public void teardown() throws Exception {
        this.mgrList = null;
        this.defaultRandom = null;
    }

    private ViewStateManagerImpl newMgr() {
        ViewStateManagerImpl mgr = new ViewStateManagerImpl((Lock)new ReentrantLock(), new ClusterSyncService(){

            public void sync(BaseTopologyView view, Runnable callback) {
                callback.run();
            }

            public void cancelSync() {
            }
        });
        this.mgrList.add(mgr);
        return mgr;
    }

    private void waitForInflightEvents(ViewStateManagerImpl mgr) throws InterruptedException {
        if (mgr == null) {
            throw new IllegalArgumentException("mgr must not be null");
        }
        if (mgr.getAsyncEventSender() == null) {
            this.logger.info("waitForInflightEvents: mgr not yet activated...");
            return;
        }
        while (mgr.getAsyncEventSender().hasInFlightEvent()) {
            this.logger.info("waitForInflightEvents: waiting 10ms...");
            Thread.sleep(10L);
        }
    }

    private void assertCountEvents(ViewStateManagerImpl mgr, DummyListener l, TopologyEvent.Type ... types) throws InterruptedException {
        StringBuffer additionalTypes;
        this.waitForInflightEvents(mgr);
        Assert.assertEquals((long)types.length, (long)l.countEvents());
        Iterator<TopologyEvent> it = l.getEvents().iterator();
        int i = 0;
        while (it.hasNext() && i < types.length) {
            TopologyEvent expectedEvent = it.next();
            TopologyEvent.Type gotType = types[i++];
            Assert.assertEquals((Object)expectedEvent.getType(), (Object)gotType);
        }
        if (it.hasNext()) {
            additionalTypes = new StringBuffer();
            while (it.hasNext()) {
                additionalTypes.append(",");
                additionalTypes.append(it.next().getType());
            }
            this.fail("got more events than expected : " + additionalTypes);
        }
        if (i < types.length) {
            additionalTypes = new StringBuffer();
            while (i < types.length) {
                additionalTypes.append(",");
                additionalTypes.append(types[i++]);
            }
            this.fail("did not get all events, also expected : " + additionalTypes);
        }
    }

    private void fail(String string) {
    }

    @Test
    public void testTwoNodes() throws Exception {
        ViewStateManagerImpl mgr1 = this.newMgr();
        String slingId1 = UUID.randomUUID().toString();
        ViewStateManagerImpl mgr2 = this.newMgr();
        String slingId2 = UUID.randomUUID().toString();
        DummyListener l1 = new DummyListener();
        mgr1.bind((TopologyEventListener)l1);
        this.assertCountEvents(mgr1, l1, new TopologyEvent.Type[0]);
        DummyListener l2 = new DummyListener();
        mgr2.bind((TopologyEventListener)l2);
        this.assertCountEvents(mgr2, l2, new TopologyEvent.Type[0]);
        mgr1.handleChanging();
        this.assertCountEvents(mgr1, l1, new TopologyEvent.Type[0]);
        mgr1.handleActivated();
        this.assertCountEvents(mgr1, l1, new TopologyEvent.Type[0]);
        mgr1.handleChanging();
        this.assertCountEvents(mgr1, l1, new TopologyEvent.Type[0]);
        mgr2.handleChanging();
        this.assertCountEvents(mgr2, l2, new TopologyEvent.Type[0]);
        mgr2.handleActivated();
        this.assertCountEvents(mgr2, l2, new TopologyEvent.Type[0]);
        mgr2.handleChanging();
        this.assertCountEvents(mgr2, l2, new TopologyEvent.Type[0]);
        DummyTopologyView vA1 = TestHelper.newView(false, slingId1, slingId1, slingId1, slingId2);
        mgr1.handleNewView((BaseTopologyView)vA1);
        this.assertCountEvents(mgr1, l1, new TopologyEvent.Type[0]);
        this.assertCountEvents(mgr2, l2, new TopologyEvent.Type[0]);
        DummyTopologyView vB1 = TestHelper.newView(false, slingId1, slingId2, slingId1, slingId2);
        mgr2.handleNewView((BaseTopologyView)vB1);
        this.assertCountEvents(mgr1, l1, new TopologyEvent.Type[0]);
        this.assertCountEvents(mgr2, l2, new TopologyEvent.Type[0]);
        DummyTopologyView vA2 = TestHelper.newView(true, slingId1, slingId1, slingId1, slingId2);
        mgr1.handleNewView((BaseTopologyView)vA2);
        this.assertCountEvents(mgr1, l1, TopologyEvent.Type.TOPOLOGY_INIT);
        this.assertCountEvents(mgr2, l2, new TopologyEvent.Type[0]);
        DummyTopologyView vB2 = TestHelper.newView(true, slingId1, slingId2, slingId1, slingId2);
        mgr2.handleNewView((BaseTopologyView)vB2);
        this.assertCountEvents(mgr1, l1, TopologyEvent.Type.TOPOLOGY_INIT);
        this.assertCountEvents(mgr2, l2, TopologyEvent.Type.TOPOLOGY_INIT);
        DummyTopologyView vB3 = TestHelper.newView(true, slingId2, slingId2, slingId2);
        mgr2.handleNewView((BaseTopologyView)vB3);
        this.assertCountEvents(mgr1, l1, TopologyEvent.Type.TOPOLOGY_INIT);
        this.assertCountEvents(mgr2, l2, TopologyEvent.Type.TOPOLOGY_INIT, TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED);
        mgr1.handleChanging();
        this.assertCountEvents(mgr1, l1, TopologyEvent.Type.TOPOLOGY_INIT, TopologyEvent.Type.TOPOLOGY_CHANGING);
        this.assertCountEvents(mgr2, l2, TopologyEvent.Type.TOPOLOGY_INIT, TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED);
        DummyTopologyView vA4 = TestHelper.newView(true, slingId2, slingId1, slingId1, slingId2);
        mgr1.handleNewView((BaseTopologyView)vA4);
        this.assertCountEvents(mgr1, l1, TopologyEvent.Type.TOPOLOGY_INIT, TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED);
        this.assertCountEvents(mgr2, l2, TopologyEvent.Type.TOPOLOGY_INIT, TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED);
        DummyTopologyView vB4 = TestHelper.newView(true, slingId2, slingId2, slingId1, slingId2);
        mgr2.handleNewView((BaseTopologyView)vA4);
        this.assertCountEvents(mgr1, l1, TopologyEvent.Type.TOPOLOGY_INIT, TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED);
        this.assertCountEvents(mgr2, l2, TopologyEvent.Type.TOPOLOGY_INIT, TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED, TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED);
    }
}

