/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.lang.reflect.Method;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.util.GenericDescriptors;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteDescriptorBuilder;
import org.junit.Assert;

public class DescriptorHelper {
    public static void setDiscoveryLiteDescriptor(ResourceResolverFactory factory, DiscoveryLiteDescriptorBuilder builder) throws Exception {
        DescriptorHelper.setDescriptor(factory, "oak.discoverylite.clusterview", builder.asJson());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDescriptor(ResourceResolverFactory factory, String key, String value) throws Exception {
        try (ResourceResolver resourceResolver = factory.getServiceResourceResolver(null);){
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                return;
            }
            Repository repo = session.getRepository();
            Method getDescriptorsMethod = repo.getClass().getDeclaredMethod("getDescriptors", new Class[0]);
            if (getDescriptorsMethod == null) {
                Assert.fail((String)"could not get 'getDescriptors' method");
            } else {
                getDescriptorsMethod.setAccessible(true);
                GenericDescriptors descriptors = (GenericDescriptors)getDescriptorsMethod.invoke((Object)repo, new Object[0]);
                SimpleValueFactory valueFactory = new SimpleValueFactory();
                descriptors.put(key, valueFactory.createValue(value), true, true);
            }
            Assert.assertEquals((Object)value, (Object)repo.getDescriptor(key));
        }
    }
}

