/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.lang.reflect.Field;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.ViewStateManager;
import org.apache.sling.discovery.commons.providers.base.DummyListener;
import org.apache.sling.discovery.commons.providers.base.TestHelper;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerFactory;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.AbstractServiceWithBackgroundCheck;
import org.apache.sling.discovery.commons.providers.spi.base.DescriptorHelper;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteConfig;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteDescriptorBuilder;
import org.apache.sling.discovery.commons.providers.spi.base.DummySlingSettingsService;
import org.apache.sling.discovery.commons.providers.spi.base.IdMapService;
import org.apache.sling.discovery.commons.providers.spi.base.OakBacklogClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.RepositoryTestHelper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOakSyncTokenService {
    private static final Logger logger = LoggerFactory.getLogger(TestOakSyncTokenService.class);
    private static final String SYNCTOKEN_PATH = "/var/discovery/commons/synctokens";
    private static final String IDMAP_PATH = "/var/discovery/commons/idmap";
    ResourceResolverFactory factory1;
    ResourceResolverFactory factory2;
    private SlingRepository repository1;
    private SlingRepository repository2;
    private MemoryNodeStore memoryNS;
    private IdMapService idMapService1;
    private String slingId1;

    @Before
    public void setup() throws Exception {
        logger.info("setup: start");
        RepositoryTestHelper.resetRepo();
        this.memoryNS = new MemoryNodeStore();
        this.repository1 = RepositoryTestHelper.newOakRepository((NodeStore)this.memoryNS);
        RepositoryTestHelper.initSlingNodeTypes(this.repository1);
        this.repository2 = RepositoryTestHelper.newOakRepository((NodeStore)this.memoryNS);
        this.factory1 = RepositoryTestHelper.mockResourceResolverFactory(this.repository1);
        this.factory2 = RepositoryTestHelper.mockResourceResolverFactory(this.repository2);
        this.slingId1 = UUID.randomUUID().toString();
        this.idMapService1 = IdMapService.testConstructor((DiscoveryLiteConfig)new SimpleCommonsConfig(), (SlingSettingsService)new DummySlingSettingsService(this.slingId1), (ResourceResolverFactory)this.factory1);
        logger.info("setup: end");
    }

    @After
    public void tearDown() throws Exception {
        logger.info("teardown: start");
        if (this.repository1 != null) {
            RepositoryTestHelper.stopRepository(this.repository1);
            this.repository1 = null;
        }
        if (this.repository2 != null) {
            RepositoryTestHelper.stopRepository(this.repository2);
            this.repository2 = null;
        }
        logger.info("teardown: end");
    }

    @Test
    public void testOneNode() throws Exception {
        logger.info("testOneNode: start");
        DummyTopologyView one = TestHelper.newView(true, this.slingId1, this.slingId1, this.slingId1);
        ReentrantLock lock = new ReentrantLock();
        OakBacklogClusterSyncService cs = OakBacklogClusterSyncService.testConstructorAndActivate((DiscoveryLiteConfig)new SimpleCommonsConfig(), (IdMapService)this.idMapService1, (SlingSettingsService)new DummySlingSettingsService(this.slingId1), (ResourceResolverFactory)this.factory1);
        ViewStateManager vsm = ViewStateManagerFactory.newViewStateManager((Lock)lock, (ClusterSyncService)cs);
        DummyListener l = new DummyListener();
        Assert.assertEquals((long)0L, (long)l.countEvents());
        vsm.bind((TopologyEventListener)l);
        cs.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)l.countEvents());
        vsm.handleActivated();
        cs.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)l.countEvents());
        vsm.handleNewView((BaseTopologyView)one);
        cs.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)l.countEvents());
        cs.triggerBackgroundCheck();
        DescriptorHelper.setDiscoveryLiteDescriptor(this.factory1, new DiscoveryLiteDescriptorBuilder().me(1).seq(1).activeIds(1).setFinal(true));
        Assert.assertTrue((boolean)this.idMapService1.waitForInit(5000L));
        cs.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)vsm.waitForAsyncEvents(1000L));
        Assert.assertEquals((long)1L, (long)l.countEvents());
        logger.info("testOneNode: end");
    }

    @Test
    public void testTwoNodesOneLeaving() throws Exception {
        logger.info("testTwoNodesOneLeaving: start");
        String slingId2 = UUID.randomUUID().toString();
        DummyTopologyView two1 = TestHelper.newView(true, this.slingId1, this.slingId1, this.slingId1, slingId2);
        ReentrantLock lock1 = new ReentrantLock();
        OakBacklogClusterSyncService cs1 = OakBacklogClusterSyncService.testConstructorAndActivate((DiscoveryLiteConfig)new SimpleCommonsConfig(), (IdMapService)this.idMapService1, (SlingSettingsService)new DummySlingSettingsService(this.slingId1), (ResourceResolverFactory)this.factory1);
        ViewStateManager vsm1 = ViewStateManagerFactory.newViewStateManager((Lock)lock1, (ClusterSyncService)cs1);
        DummyListener l = new DummyListener();
        vsm1.bind((TopologyEventListener)l);
        vsm1.handleActivated();
        vsm1.handleNewView((BaseTopologyView)two1);
        cs1.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)l.countEvents());
        DescriptorHelper.setDiscoveryLiteDescriptor(this.factory1, new DiscoveryLiteDescriptorBuilder().setFinal(true).me(1).seq(1).activeIds(1).deactivatingIds(2));
        cs1.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)l.countEvents());
        logger.info("testTwoNodesOneLeaving: sync service should be waiting for backlog to disappear");
        Thread.sleep(2000L);
        AbstractServiceWithBackgroundCheck.BackgroundCheckRunnable backgroundCheckRunnable = cs1.backgroundCheckRunnable;
        Assert.assertNotNull((Object)backgroundCheckRunnable);
        Assert.assertFalse((boolean)backgroundCheckRunnable.isDone());
        Assert.assertFalse((boolean)backgroundCheckRunnable.cancelled());
        logger.info("testTwoNodesOneLeaving: freeing backlog - sync service should finish up");
        DescriptorHelper.setDiscoveryLiteDescriptor(this.factory1, new DiscoveryLiteDescriptorBuilder().setFinal(true).me(1).seq(2).activeIds(1));
        cs1.triggerBackgroundCheck();
        Thread.sleep(2000L);
        backgroundCheckRunnable = cs1.backgroundCheckRunnable;
        Assert.assertNotNull((Object)backgroundCheckRunnable);
        Assert.assertFalse((boolean)backgroundCheckRunnable.cancelled());
        Assert.assertTrue((boolean)backgroundCheckRunnable.isDone());
        Assert.assertEquals((long)0L, (long)vsm1.waitForAsyncEvents(1000L));
        logger.info("testTwoNodesOneLeaving: setting up 2nd node");
        ReentrantLock lock2 = new ReentrantLock();
        IdMapService idMapService2 = IdMapService.testConstructor((DiscoveryLiteConfig)new SimpleCommonsConfig(), (SlingSettingsService)new DummySlingSettingsService(slingId2), (ResourceResolverFactory)this.factory2);
        OakBacklogClusterSyncService cs2 = OakBacklogClusterSyncService.testConstructorAndActivate((DiscoveryLiteConfig)new SimpleCommonsConfig(), (IdMapService)idMapService2, (SlingSettingsService)new DummySlingSettingsService(slingId2), (ResourceResolverFactory)this.factory2);
        ViewStateManager vsm2 = ViewStateManagerFactory.newViewStateManager((Lock)lock2, (ClusterSyncService)cs2);
        cs1.triggerBackgroundCheck();
        cs2.triggerBackgroundCheck();
        Assert.assertEquals((long)1L, (long)l.countEvents());
        DescriptorHelper.setDiscoveryLiteDescriptor(this.factory2, new DiscoveryLiteDescriptorBuilder().setFinal(true).me(2).seq(3).activeIds(1, 2));
        cs1.triggerBackgroundCheck();
        cs2.triggerBackgroundCheck();
        Assert.assertEquals((long)1L, (long)l.countEvents());
        DescriptorHelper.setDiscoveryLiteDescriptor(this.factory1, new DiscoveryLiteDescriptorBuilder().setFinal(true).me(1).seq(3).activeIds(1, 2));
        cs1.triggerBackgroundCheck();
        cs2.triggerBackgroundCheck();
        Assert.assertEquals((long)1L, (long)l.countEvents());
        vsm2.handleActivated();
        Assert.assertTrue((boolean)this.idMapService1.waitForInit(5000L));
        Assert.assertTrue((boolean)idMapService2.waitForInit(5000L));
        DummyTopologyView two2 = TestHelper.newView(two1.getLocalClusterSyncTokenId(), two1.getLocalInstance().getClusterView().getId(), true, this.slingId1, this.slingId1, this.slingId1, slingId2);
        vsm2.handleNewView((BaseTopologyView)two2);
        cs1.triggerBackgroundCheck();
        cs1.triggerBackgroundCheck();
        cs2.triggerBackgroundCheck();
        cs2.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)vsm1.waitForAsyncEvents(1000L));
        Assert.assertEquals((long)1L, (long)l.countEvents());
        logger.info("testTwoNodesOneLeaving: removing instance2 from the view - even though vsm1 didn't really know about it, it should send a TOPOLOGY_CHANGING - we leave it as deactivating for now...");
        DummyTopologyView oneLeaving = two1.clone();
        oneLeaving.removeInstance(slingId2);
        DescriptorHelper.setDiscoveryLiteDescriptor(this.factory1, new DiscoveryLiteDescriptorBuilder().setFinal(true).me(1).seq(1).activeIds(1).deactivatingIds(2));
        vsm1.handleNewView((BaseTopologyView)oneLeaving);
        cs1.triggerBackgroundCheck();
        cs2.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)vsm1.waitForAsyncEvents(5000L));
        Assert.assertEquals((long)2L, (long)l.countEvents());
        logger.info("testTwoNodesOneLeaving: marking instance2 as no longer deactivating, so vsm1 should now send a TOPOLOGY_CHANGED");
        DescriptorHelper.setDiscoveryLiteDescriptor(this.factory1, new DiscoveryLiteDescriptorBuilder().setFinal(true).me(1).seq(2).activeIds(1).inactiveIds(2));
        cs1.triggerBackgroundCheck();
        cs2.triggerBackgroundCheck();
        Assert.assertEquals((long)0L, (long)vsm1.waitForAsyncEvents(5000L));
        RepositoryTestHelper.dumpRepo(this.factory1);
        Assert.assertEquals((long)3L, (long)l.countEvents());
    }

    @Test
    public void testRapidIdMapServiceActivateDeactivate() throws Exception {
        AbstractServiceWithBackgroundCheck.BackgroundCheckRunnable bgCheckRunnable = this.getBackgroundCheckRunnable(this.idMapService1);
        Assert.assertNotNull((Object)bgCheckRunnable);
        Assert.assertFalse((boolean)bgCheckRunnable.isDone());
        this.idMapService1.deactivate();
        Assert.assertFalse((boolean)this.idMapService1.waitForInit(2500L));
        bgCheckRunnable = this.getBackgroundCheckRunnable(this.idMapService1);
        Assert.assertNotNull((Object)bgCheckRunnable);
        Assert.assertTrue((boolean)bgCheckRunnable.isDone());
    }

    private AbstractServiceWithBackgroundCheck.BackgroundCheckRunnable getBackgroundCheckRunnable(IdMapService idMapService) throws NoSuchFieldException, IllegalAccessException {
        Field field = idMapService.getClass().getSuperclass().getDeclaredField("backgroundCheckRunnable");
        field.setAccessible(true);
        Object backgroundCheckRunnable = field.get(idMapService);
        return (AbstractServiceWithBackgroundCheck.BackgroundCheckRunnable)backgroundCheckRunnable;
    }

    public final class SimpleCommonsConfig
    implements DiscoveryLiteConfig {
        private long bgIntervalMillis;
        private long bgTimeoutMillis;

        SimpleCommonsConfig() {
            this(1000L, -1L);
        }

        SimpleCommonsConfig(long bgIntervalMillis, long bgTimeoutMillis) {
            this.bgIntervalMillis = bgIntervalMillis;
            this.bgTimeoutMillis = bgTimeoutMillis;
        }

        public String getSyncTokenPath() {
            return TestOakSyncTokenService.SYNCTOKEN_PATH;
        }

        public String getIdMapPath() {
            return TestOakSyncTokenService.IDMAP_PATH;
        }

        public long getClusterSyncServiceTimeoutMillis() {
            return this.bgTimeoutMillis;
        }

        public long getClusterSyncServiceIntervalMillis() {
            return this.bgIntervalMillis;
        }
    }
}

