/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class DiscoveryLiteDescriptorBuilder {
    private int seqNum;
    private int me;
    private Integer[] activeIds = new Integer[0];
    private Integer[] inactiveIds = new Integer[0];
    private Integer[] deactivating = new Integer[0];
    private String id;
    private boolean isFinal = false;

    public String toString() {
        try {
            return this.asJson();
        }
        catch (JsonException e) {
            return "A DiscoLite[" + (Object)((Object)e) + "]";
        }
    }

    public DiscoveryLiteDescriptorBuilder setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public DiscoveryLiteDescriptorBuilder seq(int seqNum) {
        this.seqNum = seqNum;
        return this;
    }

    public DiscoveryLiteDescriptorBuilder me(int me) {
        this.me = me;
        return this;
    }

    public DiscoveryLiteDescriptorBuilder id(String id) {
        this.id = id;
        return this;
    }

    public DiscoveryLiteDescriptorBuilder activeIds(Integer ... activeIds) {
        this.activeIds = activeIds;
        return this;
    }

    public DiscoveryLiteDescriptorBuilder inactiveIds(Integer ... inactiveIds) {
        this.inactiveIds = inactiveIds;
        return this;
    }

    public DiscoveryLiteDescriptorBuilder deactivatingIds(Integer ... deactivating) {
        this.deactivating = deactivating;
        return this;
    }

    public String asJson() {
        JsonObjectBuilder json = Json.createObjectBuilder();
        if (this.id != null) {
            json.add("id", this.id);
        }
        json.add("final", this.isFinal);
        json.add("me", this.me);
        json.add("seq", this.seqNum);
        json.add("active", (JsonValue)this.toArray(Arrays.asList(this.activeIds)));
        json.add("inactive", (JsonValue)this.toArray(Arrays.asList(this.inactiveIds)));
        json.add("deactivating", (JsonValue)this.toArray(Arrays.asList(this.deactivating)));
        StringWriter writer = new StringWriter();
        Json.createGenerator((Writer)writer).write((JsonValue)json.build()).close();
        return writer.toString();
    }

    private JsonArray toArray(List<Integer> values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Integer value : values) {
            builder.add(value.intValue());
        }
        return builder.build();
    }
}

