/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.discovery.base.its.setup.mock.MockFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiMock {
    private static final Logger logger = LoggerFactory.getLogger(OSGiMock.class);
    private final List<Object> services = new LinkedList<Object>();

    public void addService(Object service) {
        if (service == null) {
            throw new IllegalArgumentException("service must not be null");
        }
        this.services.add(service);
    }

    public void activateAll() throws Exception {
        for (Object aService : this.services) {
            OSGiMock.activate(aService);
        }
    }

    public static void activate(Object aService) throws IllegalAccessException, InvocationTargetException {
        for (Class<?> clazz = aService.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("activate")) continue;
                method.setAccessible(true);
                if (method.getParameterTypes().length == 0) {
                    logger.info("activate: activating " + aService + "...");
                    method.invoke(aService, null);
                    logger.info("activate: activating " + aService + " done.");
                } else if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == ComponentContext.class) {
                    logger.info("activate: activating " + aService + "...");
                    method.invoke(aService, MockFactory.mockComponentContext());
                    logger.info("activate: activating " + aService + " done.");
                } else if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == BundleContext.class) {
                    logger.info("activate: activating " + aService + "...");
                    method.invoke(aService, MockFactory.mockBundleContext());
                    logger.info("activate: activating " + aService + " done.");
                } else {
                    throw new IllegalStateException("unsupported activate variant: " + method);
                }
                return;
            }
        }
    }

    public void deactivateAll() throws Exception {
        for (Object aService : this.services) {
            OSGiMock.deactivate(aService);
        }
    }

    public static void deactivate(Object aService) throws IllegalAccessException, InvocationTargetException {
        for (Class<?> clazz = aService.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("deactivate")) continue;
                method.setAccessible(true);
                if (method.getParameterTypes().length == 0) {
                    method.invoke(aService, null);
                } else {
                    method.invoke(aService, MockFactory.mockComponentContext());
                }
                return;
            }
        }
    }

    public void addServices(Object[] additionalServices) {
        if (additionalServices == null) {
            return;
        }
        for (Object additionalService : additionalServices) {
            this.addService(additionalService);
        }
    }
}

