/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.base.commons.PeriodicBackgroundJob;
import org.apache.sling.discovery.base.commons.ViewChecker;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseViewChecker
implements ViewChecker,
Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REG_PROPERTY_ENDPOINTS = "osgi.http.endpoint";
    private static final String REG_PROPERTY_ENDPOINTS_RFC = "osgi.http.service.endpoints";
    protected static final String PROPERTY_ID_ENDPOINTS = "endpoints";
    protected static final String PROPERTY_ID_SLING_HOME_PATH = "slingHomePath";
    protected static final String PROPERTY_ID_RUNTIME = "runtimeId";
    protected String NAME = "discovery.impl.heartbeat.runner.";
    protected String slingId;
    protected String runtimeId;
    protected final Object lock = new Object();
    protected volatile boolean activated = false;
    protected ComponentContext context;
    private boolean forcePing;
    protected final Map<Long, String[]> endpoints = new HashMap<Long, String[]>();
    protected PeriodicBackgroundJob periodicPingJob;

    protected abstract SlingSettingsService getSlingSettingsService();

    protected abstract ResourceResolverFactory getResourceResolverFactory();

    protected abstract ConnectorRegistry getConnectorRegistry();

    protected abstract AnnouncementRegistry getAnnouncementRegistry();

    protected abstract Scheduler getScheduler();

    protected abstract BaseConfig getConnectorConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) {
        Object object = this.lock;
        synchronized (object) {
            this.context = context;
            this.slingId = this.getSlingSettingsService().getSlingId();
            this.NAME = "discovery.connectors.common.runner." + this.slingId;
            this.doActivate();
            this.activated = true;
            this.issueHeartbeat();
        }
    }

    protected void doActivate() {
        try {
            long interval = this.getConnectorConfig().getConnectorPingInterval();
            this.logger.info("doActivate: starting periodic connectorPing job for " + this.slingId + " with interval " + interval + " sec.");
            this.periodicPingJob = new PeriodicBackgroundJob(interval, this.NAME, this);
        }
        catch (Exception e) {
            this.logger.error("doActivate: Could not start connectorPing runner: " + e, (Throwable)e);
        }
        this.logger.info("doActivate: activated with slingId: {}, this: {}", (Object)this.slingId, (Object)this);
    }

    @Deactivate
    protected void deactivate() {
        this.activated = false;
        this.logger.info("deactivate: deactivated slingId: {}, this: {}", (Object)this.slingId, (Object)this);
        if (this.periodicPingJob != null) {
            this.periodicPingJob.stop();
            this.periodicPingJob = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkView() {
        Object object = this.lock;
        synchronized (object) {
            this.doCheckView();
        }
    }

    @Override
    public void run() {
        this.heartbeatAndCheckView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartbeatAndCheckView() {
        this.logger.debug("heartbeatAndCheckView: start. [for slingId=" + this.slingId + "]");
        Object object = this.lock;
        synchronized (object) {
            if (!this.activated) {
                this.logger.debug("heartbeatAndCheckView: not activated yet");
                return;
            }
            this.issueHeartbeat();
            this.doCheckView();
        }
        this.logger.debug("heartbeatAndCheckView: end. [for slingId=" + this.slingId + "]");
    }

    public void triggerAsyncConnectorPing() {
        this.forcePing = true;
        try {
            this.logger.debug("triggerAsyncConnectorPing: firing job to trigger heartbeat");
            this.getScheduler().schedule((Object)this, this.getScheduler().NOW().name(this.NAME + UUID.randomUUID()));
        }
        catch (Exception e) {
            this.logger.info("triggerAsyncConnectorPing: Could not trigger heartbeat: " + e);
        }
    }

    protected void issueHeartbeat() {
        this.updateProperties();
        this.issueConnectorPings();
    }

    protected abstract void updateProperties();

    protected void issueConnectorPings() {
        if (this.getConnectorRegistry() == null) {
            this.logger.error("issueConnectorPings: connectorRegistry is null");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("issueConnectorPings: pinging outgoing topology connectors (if there is any) for " + this.slingId);
        }
        this.getConnectorRegistry().pingOutgoingConnectors(this.forcePing);
        this.forcePing = false;
    }

    protected void doCheckView() {
        if (this.getAnnouncementRegistry() == null) {
            this.logger.info("announcementRegistry is null (will check view again later)");
            return;
        }
        this.getAnnouncementRegistry().checkExpiredAnnouncements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindHttpService(ServiceReference reference) {
        String[] endpointUrls = this.toStringArray(reference.getProperty(REG_PROPERTY_ENDPOINTS));
        if (endpointUrls == null) {
            endpointUrls = this.toStringArray(reference.getProperty(REG_PROPERTY_ENDPOINTS_RFC));
        }
        if (endpointUrls != null) {
            Object object = this.lock;
            synchronized (object) {
                this.endpoints.put((Long)reference.getProperty("service.id"), endpointUrls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindHttpService(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpoints.remove(reference.getProperty("service.id")) != null) {
                // empty if block
            }
        }
    }

    private String[] toStringArray(Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue instanceof String) {
            return new String[]{(String)propValue};
        }
        if (propValue instanceof String[]) {
            return (String[])propValue;
        }
        if (propValue.getClass().isArray()) {
            Object[] valueArray = (Object[])propValue;
            ArrayList<String> values = new ArrayList<String>(valueArray.length);
            for (Object value : valueArray) {
                if (value == null) continue;
                values.add(value.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (propValue instanceof Collection) {
            Collection valueCollection = (Collection)propValue;
            ArrayList<String> valueList = new ArrayList<String>(valueCollection.size());
            for (Object value : valueCollection) {
                if (value == null) continue;
                valueList.add(value.toString());
            }
            return valueList.toArray(new String[valueList.size()]);
        }
        return null;
    }

    protected String getEndpointsAsString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String[] points : this.endpoints.values()) {
            for (String point : points) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(point);
            }
        }
        return sb.toString();
    }
}

