/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup.mock;

import java.util.Dictionary;
import java.util.Properties;
import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.testing.jcr.RepositoryUtil;
import org.apache.sling.discovery.base.its.setup.mock.DummyResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.action.ReturnValueAction;
import org.jmock.lib.action.VoidAction;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class MockFactory {
    public final Mockery context = new JUnit4Mockery();

    public static ResourceResolverFactory mockResourceResolverFactory() throws Exception {
        return MockFactory.mockResourceResolverFactory((SlingRepository)null);
    }

    public static ResourceResolverFactory mockResourceResolverFactory(JackrabbitRepository jcrRepo) {
        DummyResourceResolverFactory factory = new DummyResourceResolverFactory();
        RepositoryUtil.RepositoryWrapper slingRepo = new RepositoryUtil.RepositoryWrapper((Repository)jcrRepo);
        factory.setSlingRepository((SlingRepository)slingRepo);
        factory.setJackrabbitRepository(jcrRepo);
        return factory;
    }

    public static ResourceResolverFactory mockResourceResolverFactory(SlingRepository repositoryOrNull) throws Exception {
        DummyResourceResolverFactory factory = new DummyResourceResolverFactory();
        factory.setSlingRepository(repositoryOrNull);
        return factory;
    }

    public static SlingSettingsService mockSlingSettingsService(final String slingId) {
        JUnit4Mockery context = new JUnit4Mockery();
        final SlingSettingsService settingsService = (SlingSettingsService)context.mock(SlingSettingsService.class);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SlingSettingsService)this.allowing(settingsService)).getSlingId();
                this.will(1.returnValue((Object)slingId));
                ((SlingSettingsService)this.allowing(settingsService)).getSlingHomePath();
                this.will(1.returnValue((Object)"/n/a"));
            }
        });
        return settingsService;
    }

    public static ComponentContext mockComponentContext() {
        JUnit4Mockery context = new JUnit4Mockery();
        final BundleContext bc = (BundleContext)context.mock(BundleContext.class);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BundleContext)this.allowing(bc)).registerService((String)this.with(2.any(String.class)), this.with(2.any(Object.class)), (Dictionary)this.with(2.any(Dictionary.class)));
                this.will((Action)VoidAction.INSTANCE);
                ((BundleContext)this.allowing(bc)).getProperty((String)this.with(2.any(String.class)));
                this.will((Action)new ReturnValueAction((Object)"foo"));
            }
        });
        final ComponentContext cc = (ComponentContext)context.mock(ComponentContext.class);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ComponentContext)this.allowing(cc)).getProperties();
                this.will(3.returnValue((Object)new Properties()));
                ((ComponentContext)this.allowing(cc)).getBundleContext();
                this.will(3.returnValue((Object)bc));
            }
        });
        return cc;
    }

    public static BundleContext mockBundleContext() {
        return MockFactory.mockComponentContext().getBundleContext();
    }
}

