/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup.mock;

import java.util.LinkedList;
import java.util.List;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.base.its.setup.mock.AcceptsParticularTopologyEvent;
import org.apache.sling.discovery.base.its.setup.mock.TopologyEventAsserter;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertingTopologyEventListener
implements TopologyEventListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<TopologyEventAsserter> expectedEvents = new LinkedList<TopologyEventAsserter>();
    private String debugInfo = null;
    private String errorMsg = null;
    private List<TopologyEvent> events_ = new LinkedList<TopologyEvent>();
    private List<TopologyEvent> unexpectedEvents_ = new LinkedList<TopologyEvent>();

    public AssertingTopologyEventListener() {
    }

    public AssertingTopologyEventListener(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String toString() {
        return super.toString() + "-[debugInfo=" + this.debugInfo + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTopologyEvent(TopologyEvent event) {
        String logPrefix = "handleTopologyEvent[" + (this.debugInfo != null ? this.debugInfo : "this=" + this) + "] ";
        this.logger.info(logPrefix + "got event=" + event);
        TopologyEventAsserter asserter = null;
        List<TopologyEventAsserter> list = this.expectedEvents;
        synchronized (list) {
            if (this.expectedEvents.size() == 0) {
                this.unexpectedEvents_.add(event);
                throw new IllegalStateException("no expected events anymore. But got: " + event);
            }
            asserter = this.expectedEvents.remove(0);
        }
        if (asserter == null) {
            throw new IllegalStateException("this should not occur");
        }
        try {
            asserter.assertOk(event);
            this.logger.info(logPrefix + "event matched expectations (" + event + ")");
        }
        catch (RuntimeException re) {
            List<TopologyEventAsserter> list2 = this.expectedEvents;
            synchronized (list2) {
                this.unexpectedEvents_.add(event);
            }
            throw re;
        }
        catch (Error er) {
            List<TopologyEventAsserter> list3 = this.expectedEvents;
            synchronized (list3) {
                this.unexpectedEvents_.add(event);
            }
            throw er;
        }
        try {
            switch (event.getType()) {
                case PROPERTIES_CHANGED: {
                    Assert.assertNotNull((Object)event.getOldView());
                    Assert.assertNotNull((Object)event.getNewView());
                    Assert.assertTrue((boolean)event.getNewView().isCurrent());
                    Assert.assertFalse((boolean)event.getOldView().isCurrent());
                    break;
                }
                case TOPOLOGY_CHANGED: {
                    Assert.assertNotNull((Object)event.getOldView());
                    Assert.assertNotNull((Object)event.getNewView());
                    Assert.assertTrue((boolean)event.getNewView().isCurrent());
                    Assert.assertFalse((boolean)event.getOldView().isCurrent());
                    break;
                }
                case TOPOLOGY_CHANGING: {
                    Assert.assertNotNull((Object)event.getOldView());
                    Assert.assertNull((Object)event.getNewView());
                    Assert.assertFalse((boolean)event.getOldView().isCurrent());
                    break;
                }
                case TOPOLOGY_INIT: {
                    Assert.assertNull((Object)event.getOldView());
                    Assert.assertNotNull((Object)event.getNewView());
                }
            }
        }
        catch (RuntimeException re) {
            this.logger.error("RuntimeException: " + re, (Throwable)re);
            throw re;
        }
        catch (AssertionError e) {
            this.logger.error("AssertionError: " + e, (Throwable)((Object)e));
            throw e;
        }
        this.events_.add(event);
    }

    public List<TopologyEvent> getEvents() {
        return this.events_;
    }

    public void addExpected(TopologyEvent.Type expectedType) {
        this.addExpected(new AcceptsParticularTopologyEvent(expectedType));
    }

    public void addExpected(TopologyEventAsserter topologyEventAsserter) {
        this.expectedEvents.add(topologyEventAsserter);
    }

    public int getRemainingExpectedCount() {
        return this.expectedEvents.size();
    }

    public int getUnexpectedCount() {
        return this.unexpectedEvents_.size();
    }

    public void dump() {
        StringBuffer ue = new StringBuffer();
        if (this.unexpectedEvents_.size() > 0) {
            for (TopologyEvent topologyEvent : this.unexpectedEvents_) {
                ue.append(topologyEvent + ", ");
            }
            this.unexpectedEvents_.iterator();
        }
        this.logger.info("dump: got " + this.events_.size() + " events, " + this.unexpectedEvents_.size() + " (details: " + ue + ") thereof unexpected. My list of expected events contains " + this.expectedEvents.size());
    }
}

