/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.ping;

import java.net.URL;
import java.util.UUID;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.DummyVirtualInstanceBuilder;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistryImpl;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistryImpl;
import org.apache.sling.discovery.base.connectors.ping.TopologyConnectorClientInformation;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.discovery.base.its.setup.mock.MockFactory;
import org.apache.sling.discovery.base.its.setup.mock.SimpleConnectorConfig;
import org.apache.sling.discovery.commons.providers.spi.base.DummySlingSettingsService;
import org.apache.sling.settings.SlingSettingsService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectorRegistryImplTest {
    private VirtualInstance i;

    public VirtualInstanceBuilder newBuilder() {
        return new DummyVirtualInstanceBuilder();
    }

    @Before
    public void setup() throws Exception {
        VirtualInstanceBuilder builder = this.newBuilder().newRepository("/var/discovery/impl/", true).setDebugName("i").setConnectorPingInterval(20).setConnectorPingTimeout(20);
        this.i = builder.build();
    }

    @After
    public void teardown() throws Exception {
        if (this.i != null) {
            try {
                this.i.stopViewChecker();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.i.stop();
                throw new RuntimeException(e);
            }
            this.i.stop();
        }
    }

    @Test
    public void testRegisterUnregister() throws Exception {
        SimpleConnectorConfig config = new SimpleConnectorConfig(){

            @Override
            public long getConnectorPingTimeout() {
                return 20000L;
            }
        };
        AnnouncementRegistryImpl announcementRegistry = AnnouncementRegistryImpl.testConstructorAndActivate((ResourceResolverFactory)MockFactory.mockResourceResolverFactory(), (SlingSettingsService)new DummySlingSettingsService(UUID.randomUUID().toString()), (BaseConfig)config);
        ConnectorRegistry c = ConnectorRegistryImpl.testConstructor((AnnouncementRegistry)announcementRegistry, (BaseConfig)config);
        URL url = new URL("http://localhost:1234/connector");
        ClusterViewService cvs = this.i.getClusterViewService();
        try {
            c.registerOutgoingConnector(null, url);
            Assert.fail((String)"should have complained");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            c.registerOutgoingConnector(cvs, null);
            Assert.fail((String)"should have complained");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TopologyConnectorClientInformation client = c.registerOutgoingConnector(cvs, url);
        try {
            client = c.registerOutgoingConnector(cvs, url);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"should no longer be thrown");
        }
        try {
            c.unregisterOutgoingConnector(null);
            Assert.fail((String)"should have complained");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        c.unregisterOutgoingConnector(client.getId());
    }
}

