/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.datasource.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={DriverRegistry.class})
public class DriverRegistry {
    private static final String DRIVER_SERVICE = "META-INF/services/" + Driver.class.getName();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleTracker<Collection<DriverInfo>> bundleTracker;
    private ConcurrentMap<DriverInfo, Driver> driverInfos = new ConcurrentHashMap<DriverInfo, Driver>();

    public Collection<Driver> getDrivers() {
        return this.driverInfos.values();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new DriverBundleTracker());
        this.bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
        }
    }

    private void registerDrivers(Collection<DriverInfo> drivers) {
        for (DriverInfo di : drivers) {
            this.driverInfos.put(di, di.driver);
            this.log.info("Registering {}", (Object)di);
        }
    }

    private void deregisterDrivers(Collection<DriverInfo> drivers) {
        for (DriverInfo di : drivers) {
            this.driverInfos.remove(di);
            this.log.info("Deregistering {}", (Object)di);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DriverInfo> createDrivers(Bundle bundle) {
        URL url = bundle.getEntry(DRIVER_SERVICE);
        InputStream ins = null;
        ArrayList<DriverInfo> extensions = new ArrayList<DriverInfo>();
        try {
            String line;
            ins = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() <= 0) continue;
                try {
                    Class clazz = bundle.loadClass(line);
                    extensions.add(new DriverInfo(bundle, (Driver)clazz.newInstance()));
                }
                catch (Throwable t) {
                    this.log.warn("Cannot register java.sql.Driver [{}] from bundle [{}]", new Object[]{line, bundle, t});
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
        return extensions;
    }

    private static class DriverInfo {
        final Driver driver;
        final Bundle bundle;

        DriverInfo(Bundle bundle, Driver driver) {
            this.driver = driver;
            this.bundle = bundle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DriverInfo that = (DriverInfo)o;
            if (this.bundle != that.bundle) {
                return false;
            }
            return this.driver == that.driver;
        }

        public int hashCode() {
            int result = this.driver.hashCode();
            result = 31 * result + this.bundle.hashCode();
            return result;
        }

        public String toString() {
            return String.format("java.sql.Driver [%s] from bundle [%s]", this.driver.getClass().getName(), this.bundle);
        }
    }

    private class DriverBundleTracker
    implements BundleTrackerCustomizer<Collection<DriverInfo>> {
        private DriverBundleTracker() {
        }

        public Collection<DriverInfo> addingBundle(Bundle bundle, BundleEvent event) {
            if (bundle.getEntry(DRIVER_SERVICE) != null) {
                Collection drivers = DriverRegistry.this.createDrivers(bundle);
                DriverRegistry.this.registerDrivers(drivers);
                return drivers;
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Collection<DriverInfo> object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Collection<DriverInfo> drivers) {
            DriverRegistry.this.deregisterDrivers(drivers);
        }
    }
}

