/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Set;
import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.bytecode.Descriptor;
import org.apache.sling.cta.impl.AgentInfo;
import org.apache.sling.cta.impl.Log;

public abstract class MBeanAwareTimeoutTransformer
implements ClassFileTransformer {
    private final AgentInfo agentInfo;
    private final Set<String> classesToTransform;

    public MBeanAwareTimeoutTransformer(AgentInfo agent, Set<String> classesToTransform) {
        this.agentInfo = agent;
        this.classesToTransform = classesToTransform;
        this.agentInfo.registerTransformer(this.getClass());
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            if (this.classesToTransform.contains(className)) {
                Log.get().log("%s asked to transform %s", this.getClass().getSimpleName(), className);
                ClassPool classPool = new ClassPool(true);
                classPool.appendClassPath((ClassPath)new LoaderClassPath(loader));
                classPool.insertClassPath((ClassPath)new ByteArrayClassPath(Descriptor.toJavaName((String)className), classfileBuffer));
                CtClass cc = classPool.get(Descriptor.toJavaName((String)className));
                classfileBuffer = this.doTransformClass(cc);
                Log.get().log("Transformation of %s complete", className);
                this.agentInfo.registerTransformedClass(className);
            }
            return classfileBuffer;
        }
        catch (Exception e) {
            Log.get().fatal("Transformation failed", e);
            return null;
        }
    }

    protected abstract byte[] doTransformClass(CtClass var1) throws Exception;
}

