/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.util.Objects;

abstract class Log {
    private static Log INSTANCE;

    public static void configure(String spec) {
        INSTANCE = "v".equals(spec) ? new ConsoleLog() : new NoopLog();
    }

    public static Log get() {
        return Objects.requireNonNull(INSTANCE, "Log is null, did you foget to call Log.configure() ?");
    }

    private Log() {
    }

    public abstract void log(String var1, Object ... var2);

    public abstract void fatal(String var1, Throwable var2);

    static class NoopLog
    extends Log {
        NoopLog() {
        }

        @Override
        public void log(String msg, Object ... args) {
        }

        @Override
        public void fatal(String message, Throwable t) {
        }
    }

    static class ConsoleLog
    extends Log {
        private static final String LOG_ENTRY_PREFIX = "[AGENT] ";

        ConsoleLog() {
        }

        @Override
        public void log(String msg, Object ... args) {
            System.out.format(LOG_ENTRY_PREFIX + msg + " %n", args);
        }

        @Override
        public void fatal(String msg, Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(LOG_ENTRY_PREFIX + msg, t);
        }
    }
}

