/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.Serializable;
import java.util.Map;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class InternalScheduleOptions
implements ScheduleOptions {
    public final TriggerBuilder<? extends Trigger> trigger;
    public final IllegalArgumentException argumentException;
    public String providedName;
    public String name;
    public String threadPoolName;
    public boolean canRunConcurrently = false;
    public Map<String, Serializable> configuration;
    public String[] runOn;

    public InternalScheduleOptions(TriggerBuilder<? extends Trigger> trigger) {
        this.trigger = trigger;
        this.argumentException = null;
    }

    public InternalScheduleOptions(IllegalArgumentException iae) {
        this.trigger = null;
        this.argumentException = iae;
    }

    @Override
    public ScheduleOptions config(Map<String, Serializable> config) {
        this.configuration = config;
        return this;
    }

    @Override
    public ScheduleOptions name(String name) {
        this.name = name;
        this.providedName = name;
        return this;
    }

    @Override
    public ScheduleOptions canRunConcurrently(boolean flag) {
        this.canRunConcurrently = flag;
        return this;
    }

    @Override
    public ScheduleOptions onLeaderOnly(boolean flag) {
        this.runOn = flag ? new String[]{"LEADER"} : null;
        return this;
    }

    @Override
    public ScheduleOptions onSingleInstanceOnly(boolean flag) {
        this.runOn = flag ? new String[]{"SINGLE"} : null;
        return this;
    }

    @Override
    public ScheduleOptions onInstancesOnly(String[] slingIds) {
        this.runOn = slingIds;
        return this;
    }

    @Override
    public ScheduleOptions threadPoolName(String name) {
        this.threadPoolName = name;
        return this;
    }
}

