/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.impl.InternalScheduleOptions;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class WhiteboardHandler {
    private static final String SCHEDULED_JOB_FILTER = "(|(scheduler.expression=*)(scheduler.period=*))";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference(name="first")
    private QuartzScheduler scheduler;
    private final Map<Long, String> idToNameMap = new ConcurrentHashMap<Long, String>();

    private String getStringProperty(ServiceReference<?> ref, String name) {
        Object obj = ref.getProperty(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new IllegalArgumentException("Property " + name + " is not of type String");
    }

    private Boolean getBooleanProperty(ServiceReference<?> ref, String name) {
        Object obj = ref.getProperty(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new IllegalArgumentException("Property " + name + " is not of type Boolean");
    }

    private boolean getBooleanOrDefault(ServiceReference<?> ref, String name, boolean defaultValue) {
        Boolean value = this.getBooleanProperty(ref, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private Long getLongProperty(ServiceReference<?> ref, String name) {
        Object obj = ref.getProperty(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        throw new IllegalArgumentException("Property " + name + " is not of type Long");
    }

    private Integer getIntegerProperty(ServiceReference<?> ref, String name) {
        Object obj = ref.getProperty(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new IllegalArgumentException("Property " + name + " is not of type Integer");
    }

    private String[] getStringArray(ServiceReference<?> ref, String name) {
        Object value = ref.getProperty(name);
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value != null) {
            return new String[]{value.toString()};
        }
        return null;
    }

    private String getServiceIdentifier(ServiceReference<?> ref) {
        String name = this.getStringProperty(ref, "scheduler.name");
        if (name == null) {
            Object pid = ref.getProperty("service.pid");
            name = pid instanceof String ? (String)pid : (pid instanceof String[] ? Arrays.toString((String[])pid) : "Registered Service");
            name = name + "." + this.getLongProperty(ref, "service.id");
        }
        return name;
    }

    @Reference(service=Runnable.class, target="(|(scheduler.expression=*)(scheduler.period=*))", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="updatedRunnable")
    private void registerRunnable(ServiceReference<Runnable> ref, Runnable service) {
        this.register(ref, service);
    }

    private void unregisterRunnable(ServiceReference<Runnable> ref) {
        this.unregister(ref);
    }

    private void updatedRunnable(ServiceReference<Runnable> ref, Runnable service) {
        this.unregister(ref);
        this.register(ref, service);
    }

    @Reference(service=Job.class, target="(|(scheduler.expression=*)(scheduler.period=*))", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="updatedJob")
    private void registerJob(ServiceReference<Job> ref, Job service) {
        this.register(ref, service);
    }

    private void unregisterJob(ServiceReference<Job> ref) {
        this.unregister(ref);
    }

    private void updatedJob(ServiceReference<Job> ref, Job service) {
        this.unregister(ref);
        this.register(ref, service);
    }

    void register(ServiceReference<?> ref, Object job) {
        try {
            if (!this.tryScheduleExpression(ref, job) && !this.trySchedulePeriod(ref, job)) {
                this.logger.debug("Ignoring service {} : no scheduling property found.", ref);
            }
        }
        catch (IllegalArgumentException iae) {
            this.logger.warn("Ignoring service {} : {}", ref, (Object)iae.getMessage());
        }
    }

    void unregister(ServiceReference<?> reference) {
        Long key = this.getLongProperty(reference, "service.id");
        String name = this.idToNameMap.remove(key);
        if (name != null) {
            this.scheduler.unschedule(reference.getBundle().getBundleId(), name);
        }
    }

    private boolean trySchedulePeriod(ServiceReference<?> ref, Object job) {
        Long period = this.getLongProperty(ref, "scheduler.period");
        if (period == null) {
            return false;
        }
        if (period < 1L) {
            this.logger.debug("Ignoring service {} : scheduler period is less than 1.", ref);
        } else {
            Integer times;
            Date date = new Date();
            boolean immediate = this.getBooleanOrDefault(ref, "scheduler.immediate", false);
            if (!immediate) {
                date.setTime(System.currentTimeMillis() + period * 1000L);
            }
            if ((times = this.getIntegerProperty(ref, "scheduler.times")) != null && times < 1) {
                this.logger.debug("Ignoring service {} : scheduler times is less than 1.", ref);
            } else {
                int t = times != null ? times : -1;
                this.scheduleJob(ref, job, this.scheduler.AT(date, t, period));
                return true;
            }
        }
        return false;
    }

    private boolean tryScheduleExpression(ServiceReference<?> ref, Object job) {
        String expression = this.getStringProperty(ref, "scheduler.expression");
        if (expression != null) {
            this.scheduleJob(ref, job, this.scheduler.EXPR(expression));
            return true;
        }
        return false;
    }

    private String[] getRunOpts(ServiceReference<?> ref) {
        return this.getStringArray(ref, "scheduler.runOn");
    }

    private void scheduleJob(ServiceReference<?> ref, Object job, ScheduleOptions scheduleOptions) {
        String name = this.getServiceIdentifier(ref);
        Boolean concurrent = this.getBooleanProperty(ref, "scheduler.concurrent");
        String[] runOnOpts = this.getRunOpts(ref);
        Object poolNameObj = ref.getProperty("scheduler.threadPool");
        String poolName = poolNameObj != null && poolNameObj.toString().trim().length() > 0 ? poolNameObj.toString().trim() : null;
        ScheduleOptions options = scheduleOptions.name(name).canRunConcurrently(concurrent != null ? concurrent : true).threadPoolName(poolName).onInstancesOnly(runOnOpts);
        ((InternalScheduleOptions)scheduleOptions).providedName = this.getStringProperty(ref, "scheduler.name");
        long bundleId = ref.getBundle().getBundleId();
        Long serviceId = this.getLongProperty(ref, "service.id");
        if (this.scheduler.schedule(bundleId, serviceId, job, options)) {
            this.idToNameMap.put(serviceId, name);
        } else {
            this.logger.error("Scheduling service {} failed.", ref);
        }
    }
}

