/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.mime.internal;

import org.apache.sling.commons.mime.MimeTypeProvider;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.description=Apache Tika MIME Type Provider", "service.vendor=The Apache Software Foundation"})
public class TikaMimeTypeProvider
implements MimeTypeProvider {
    private final Tika tika = new Tika();
    private final MimeTypes types = MimeTypes.getDefaultMimeTypes();

    @Override
    public String getMimeType(String name) {
        String type = this.tika.detect(name);
        if ("application/octet-stream".equals(type)) {
            return null;
        }
        return type;
    }

    @Override
    public String getExtension(String mimeType) {
        try {
            MimeType type = this.types.forName(mimeType);
            String extension = type.getExtension();
            if (extension != null && extension.length() > 1) {
                return extension.substring(1);
            }
        }
        catch (MimeTypeException mimeTypeException) {
            // empty catch block
        }
        return null;
    }
}

