/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ObjectNameFactory;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.Histogram;
import org.apache.sling.commons.metrics.Meter;
import org.apache.sling.commons.metrics.Metric;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.commons.metrics.internal.BundleMetricsMapper;
import org.apache.sling.commons.metrics.internal.CounterImpl;
import org.apache.sling.commons.metrics.internal.GaugeManager;
import org.apache.sling.commons.metrics.internal.HistogramImpl;
import org.apache.sling.commons.metrics.internal.InternalMetricsServiceFactory;
import org.apache.sling.commons.metrics.internal.MeterImpl;
import org.apache.sling.commons.metrics.internal.TimerImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={}, immediate=true)
public class MetricsServiceImpl
implements MetricsService {
    private final List<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
    private final ConcurrentMap<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();
    private final MetricRegistry registry = new MetricRegistry();
    private final BundleMetricsMapper metricsMapper = new BundleMetricsMapper(this.registry);
    private GaugeManager gaugeManager;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private MBeanServer server;
    private JmxReporter reporter;

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        this.enableJMXReporter();
        this.gaugeManager = new GaugeManager(context, this.registry, this.metricsMapper);
        Hashtable<String, String> svcProps = new Hashtable<String, String>();
        ((Dictionary)svcProps).put("service.description", "Apache Sling Metrics Service");
        ((Dictionary)svcProps).put("service.vendor", "The Apache Software Foundation");
        this.regs.add(context.registerService(MetricsService.class.getName(), (Object)new InternalMetricsServiceFactory(this, this.metricsMapper), svcProps));
        Hashtable<String, String> regProps = new Hashtable<String, String>();
        ((Dictionary)regProps).put("service.description", "Apache Sling Metrics Registry");
        ((Dictionary)regProps).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)regProps).put("name", "sling");
        this.regs.add(context.registerService(MetricRegistry.class.getName(), (Object)this.registry, regProps));
    }

    @Deactivate
    private void deactivate() throws IOException {
        for (ServiceRegistration reg : this.regs) {
            reg.unregister();
        }
        this.regs.clear();
        this.gaugeManager.close();
        this.metrics.clear();
        if (this.reporter != null) {
            this.reporter.close();
        }
    }

    @Override
    public Timer timer(String name) {
        return this.getOrAdd(name, MetricBuilder.TIMERS);
    }

    @Override
    public Histogram histogram(String name) {
        return this.getOrAdd(name, MetricBuilder.HISTOGRAMS);
    }

    @Override
    public Counter counter(String name) {
        return this.getOrAdd(name, MetricBuilder.COUNTERS);
    }

    @Override
    public Meter meter(String name) {
        return this.getOrAdd(name, MetricBuilder.METERS);
    }

    @Override
    public <A> A adaptTo(Class<A> type) {
        if (type == MetricRegistry.class) {
            return (A)this.registry;
        }
        return null;
    }

    MetricRegistry getRegistry() {
        return this.registry;
    }

    private <T extends Metric> T getOrAdd(String name, MetricBuilder<T> builder) {
        block4: {
            Metric metric = (Metric)this.metrics.get(name);
            if (builder.isInstance(metric)) {
                return (T)metric;
            }
            if (metric == null) {
                try {
                    return this.register(name, builder.newMetric(this.registry, name));
                }
                catch (IllegalArgumentException e) {
                    Metric added = (Metric)this.metrics.get(name);
                    if (!builder.isInstance(added)) break block4;
                    return (T)added;
                }
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    private <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        Metric existing = this.metrics.putIfAbsent(name, metric);
        if (existing != null) {
            throw new IllegalArgumentException("A metric named " + name + " already exists");
        }
        return metric;
    }

    private void enableJMXReporter() {
        if (this.server == null) {
            this.server = ManagementFactory.getPlatformMBeanServer();
        }
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.registry).inDomain("org.apache.sling").createsObjectNamesWith((ObjectNameFactory)this.metricsMapper).registerWith(this.server).build();
        this.reporter.start();
    }

    private static interface MetricBuilder<T extends Metric> {
        public static final MetricBuilder<Counter> COUNTERS = new MetricBuilder<Counter>(){

            @Override
            public Counter newMetric(MetricRegistry registry, String name) {
                return new CounterImpl(registry.counter(name));
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Counter.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Histogram> HISTOGRAMS = new MetricBuilder<Histogram>(){

            @Override
            public Histogram newMetric(MetricRegistry registry, String name) {
                return new HistogramImpl(registry.histogram(name));
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Histogram.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Meter> METERS = new MetricBuilder<Meter>(){

            @Override
            public Meter newMetric(MetricRegistry registry, String name) {
                return new MeterImpl(registry.meter(name));
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Meter.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Timer> TIMERS = new MetricBuilder<Timer>(){

            @Override
            public Timer newMetric(MetricRegistry registry, String name) {
                return new TimerImpl(registry.timer(name));
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Timer.class.isInstance(metric);
            }
        };

        public T newMetric(MetricRegistry var1, String var2);

        public boolean isInstance(Metric var1);
    }
}

