/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.joran;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.AppenderAttachable;
import org.apache.sling.commons.log.logback.internal.AppenderOrigin;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.joran.OsgiAppenderRefModel;
import org.jetbrains.annotations.NotNull;

class OsgiAppenderRefModelHandler
extends ModelHandlerBase {
    private LogConfigManager logConfigManager;

    public OsgiAppenderRefModelHandler(@NotNull Context context, @NotNull LogConfigManager manager) {
        super(context);
        this.logConfigManager = manager;
    }

    @NotNull
    protected Class<? extends OsgiAppenderRefModel> getSupportedModelClass() {
        return OsgiAppenderRefModel.class;
    }

    @Override
    public void handle(@NotNull ModelInterpretationContext interpContext, @NotNull Model model) throws ModelHandlerException {
        Object o = interpContext.peekObject();
        if (!(o instanceof AppenderAttachable)) {
            String errMsg = "Could not find an AppenderAttachable at the top of execution stack. Near " + model.idString();
            this.addError(errMsg);
            return;
        }
        OsgiAppenderRefModel appenderRefModel = (OsgiAppenderRefModel)model;
        AppenderAttachable appenderAttachable = (AppenderAttachable)o;
        this.attachOsgiReferencedAppenders(interpContext, appenderRefModel, appenderAttachable);
    }

    void attachOsgiReferencedAppenders(@NotNull ModelInterpretationContext mic, @NotNull OsgiAppenderRefModel appenderRefModel, @NotNull AppenderAttachable<?> appenderAttachable) {
        String appenderName = mic.subst(appenderRefModel.getRef());
        if (appenderAttachable instanceof Logger) {
            String loggerName = ((Logger)appenderAttachable).getName();
            this.logConfigManager.addedAppenderRef(AppenderOrigin.JORAN_OSGI, appenderName, loggerName);
        } else {
            this.addError("Failed to add osgi appender named [" + appenderName + "] as the attachable is not a Logger.");
        }
    }
}

