/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.apache.johnzon.core.DiffBase;
import org.apache.johnzon.core.JsonPatchBuilderImpl;
import org.apache.johnzon.core.JsonPointerUtil;

class JsonPatchDiff
extends DiffBase {
    private final JsonProvider provider;
    private final JsonStructure source;
    private final JsonStructure target;

    JsonPatchDiff(JsonProvider provider, JsonStructure source, JsonStructure target) {
        this.provider = provider;
        this.source = source;
        this.target = target;
    }

    JsonPatch calculateDiff() {
        JsonPatchBuilderImpl patchBuilder = new JsonPatchBuilderImpl(this.provider);
        this.diff(patchBuilder, "", this.source, this.target);
        return patchBuilder.build();
    }

    private void diff(JsonPatchBuilder patchBuilder, String basePath, JsonValue source, JsonValue target) {
        if (this.isJsonObject(source) && this.isJsonObject(target)) {
            this.diffJsonObjects(patchBuilder, basePath + "/", (JsonObject)source, (JsonObject)target);
        } else if (this.isJsonArray(source) && this.isJsonArray(target)) {
            this.diffJsonArray(patchBuilder, basePath + "/", (JsonArray)source, (JsonArray)target);
        } else if (!source.equals(target)) {
            patchBuilder.replace(basePath, target);
        }
    }

    private void diffJsonArray(JsonPatchBuilder patchBuilder, String basePath, JsonArray source, JsonArray target) {
        int i;
        for (i = 0; i < source.size(); ++i) {
            JsonValue sourceValue = (JsonValue)source.get(i);
            if (target.size() <= i) {
                patchBuilder.remove(basePath + i);
                continue;
            }
            this.diff(patchBuilder, basePath + i, sourceValue, (JsonValue)target.get(i));
        }
        if (target.size() > source.size()) {
            for (i = target.size() - source.size(); i < target.size(); ++i) {
                patchBuilder.add(basePath + i, (JsonValue)target.get(i));
            }
        }
    }

    private void diffJsonObjects(JsonPatchBuilder patchBuilder, String basePath, JsonObject source, JsonObject target) {
        for (Map.Entry sourceEntry : source.entrySet()) {
            String attributeName = (String)sourceEntry.getKey();
            if (target.containsKey(attributeName)) {
                this.diff(patchBuilder, basePath + JsonPointerUtil.encode(attributeName), (JsonValue)sourceEntry.getValue(), (JsonValue)target.get(attributeName));
                continue;
            }
            patchBuilder.remove(basePath + JsonPointerUtil.encode(attributeName));
        }
        for (Map.Entry targetEntry : target.entrySet()) {
            if (source.containsKey(targetEntry.getKey())) continue;
            patchBuilder.add(basePath + JsonPointerUtil.encode((String)targetEntry.getKey()), (JsonValue)targetEntry.getValue());
        }
    }
}

