/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.apache.johnzon.core.JohnzonJsonParser;
import org.apache.johnzon.core.JsonArrayBuilderImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;
import org.apache.johnzon.core.JsonStringImpl;

public class JsonReaderImpl
implements JsonReader {
    private final JohnzonJsonParser parser;
    private boolean closed = false;

    public JsonReaderImpl(JsonParser parser) {
        this.parser = parser instanceof JohnzonJsonParser ? (JohnzonJsonParser)parser : new JohnzonJsonParser.JohnzonJsonParserWrapper(parser);
    }

    @Override
    public JsonStructure read() {
        return (JsonStructure)JsonStructure.class.cast(this.readValue());
    }

    @Override
    public JsonValue readValue() {
        this.checkClosed();
        if (!this.parser.hasNext()) {
            throw new IllegalStateException("Nothing to read");
        }
        JsonParser.Event next = this.parser.next();
        switch (next) {
            case START_OBJECT: {
                JsonObjectBuilderImpl objectBuilder = new JsonObjectBuilderImpl();
                this.parseObject(objectBuilder);
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                this.close();
                return objectBuilder.build();
            }
            case START_ARRAY: {
                JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
                this.parseArray(arrayBuilder);
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                this.close();
                return arrayBuilder.build();
            }
            case VALUE_STRING: {
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                JsonStringImpl string = new JsonStringImpl(this.parser.getString());
                this.close();
                return string;
            }
            case VALUE_FALSE: {
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                this.close();
                return JsonValue.FALSE;
            }
            case VALUE_TRUE: {
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                this.close();
                return JsonValue.TRUE;
            }
            case VALUE_NULL: {
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                this.close();
                return JsonValue.NULL;
            }
            case VALUE_NUMBER: {
                if (this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                JsonNumberImpl number = new JsonNumberImpl(this.parser.getBigDecimal());
                this.close();
                return number;
            }
        }
        this.close();
        throw new JsonParsingException("Unknown structure: " + (Object)((Object)next), this.parser.getLocation());
    }

    @Override
    public JsonObject readObject() {
        JsonStructure read = this.read();
        this.checkType(JsonObject.class, read);
        return (JsonObject)JsonObject.class.cast(read);
    }

    @Override
    public JsonArray readArray() {
        JsonStructure read = this.read();
        this.checkType(JsonArray.class, read);
        return (JsonArray)JsonArray.class.cast(read);
    }

    private void checkType(Class<?> expected, JsonStructure read) {
        if (!expected.isInstance(read)) {
            throw new JsonParsingException("Expecting " + expected + " but got " + read, this.parser.getLocation());
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.parser.close();
        }
    }

    private void parseObject(JsonObjectBuilder builder) {
        String key = null;
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case KEY_NAME: {
                    key = this.parser.getString();
                    continue block12;
                }
                case VALUE_STRING: {
                    builder.add(key, new JsonStringImpl(this.parser.getString()));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilderImpl subObject = null;
                    subObject = new JsonObjectBuilderImpl();
                    this.parseObject(subObject);
                    builder.add(key, subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilderImpl subArray = null;
                    subArray = new JsonArrayBuilderImpl();
                    this.parseArray(subArray);
                    builder.add(key, subArray);
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber() && this.parser.isNotTooLong()) {
                        builder.add(key, new JsonLongImpl(this.parser.getLong()));
                        continue block12;
                    }
                    builder.add(key, new JsonNumberImpl(this.parser.getBigDecimal()));
                    continue block12;
                }
                case VALUE_NULL: {
                    builder.addNull(key);
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(key, true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(key, false);
                    continue block12;
                }
                case END_OBJECT: {
                    return;
                }
                case END_ARRAY: {
                    throw new JsonParsingException("']', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }

    private void parseArray(JsonArrayBuilder builder) {
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case VALUE_STRING: {
                    builder.add(new JsonStringImpl(this.parser.getString()));
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber()) {
                        builder.add(new JsonLongImpl(this.parser.getLong()));
                        continue block12;
                    }
                    builder.add(new JsonNumberImpl(this.parser.getBigDecimal()));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilderImpl subObject = null;
                    subObject = new JsonObjectBuilderImpl();
                    this.parseObject(subObject);
                    builder.add(subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilderImpl subArray = null;
                    subArray = new JsonArrayBuilderImpl();
                    this.parseArray(subArray);
                    builder.add(subArray);
                    continue block12;
                }
                case END_ARRAY: {
                    return;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(false);
                    continue block12;
                }
                case KEY_NAME: {
                    throw new JsonParsingException("array doesn't have keys", this.parser.getLocation());
                }
                case END_OBJECT: {
                    throw new JsonParsingException("'}', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("read(), readObject(), readArray() or close() method was already called");
        }
    }
}

