/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.sling.commons.fsclassloader.FSClassLoaderMBean;
import org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider;
import org.apache.sling.commons.fsclassloader.impl.FSClassLoaderWebConsole;
import org.apache.sling.commons.fsclassloader.impl.ScriptFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSClassLoaderMBeanImpl
implements FSClassLoaderMBean {
    private final File root;
    private final FSClassLoaderProvider fsClassLoaderProvider;
    private static final Logger log = LoggerFactory.getLogger(FSClassLoaderMBeanImpl.class);

    public FSClassLoaderMBeanImpl(FSClassLoaderProvider fsClassLoaderProvider, File root) {
        this.fsClassLoaderProvider = fsClassLoaderProvider;
        this.root = root;
    }

    @Override
    public int getCachedScriptCount() throws IOException {
        return this.getScripts().size();
    }

    @Override
    public List<String> getCachedScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.addAll(this.getScripts());
        Collections.sort(scripts);
        return scripts;
    }

    private Collection<String> getScripts() {
        Set<String> scripts = new HashSet<String>();
        try {
            LinkedHashMap<String, ScriptFiles> s = new LinkedHashMap<String, ScriptFiles>();
            if (this.root != null) {
                FSClassLoaderWebConsole.readFiles(this.root, this.root, s);
            }
            scripts = s.keySet();
        }
        catch (Exception e) {
            log.warn("Exception retrieving scripts from FSClassLoader", (Throwable)e);
        }
        return scripts;
    }

    @Override
    public void clearCache() {
        this.fsClassLoaderProvider.delete("");
    }

    @Override
    public String getFSClassLoaderRoot() {
        return this.root.getAbsolutePath();
    }
}

