/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.jasypt.internal;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@ObjectClassDefinition(name="Apache Sling Commons Crypto \u201cJasypt Standard PBE String Crypto Service\u201d", description="Crypto service which uses Jasypt StandardPBEStringEncryptor for encryption and decryption")
@interface JasyptStandardPBEStringCryptoServiceConfiguration {
    @AttributeDefinition(name="Names", description="names of this service", required=false)
    public String[] names() default {};

    @AttributeDefinition(name="Algorithm", description="crypto algorithm")
    public String algorithm() default "PBEWITHHMACSHA512ANDAES_256";

    @AttributeDefinition(name="Key Obtention Iterations", description="number of hashing iterations applied for obtaining the encryption key from the specified password")
    public int keyObtentionIterations() default 1000;

    @AttributeDefinition(name="Security Provider Name", description="name of the Security Provider", required=false)
    public String securityProviderName();

    @AttributeDefinition(name="String Output Type", description="encoding format of the encrypted string output", options={@Option(label="Base16 (hexadecimal)", value="hexadecimal"), @Option(label="Base64", value="base64")})
    public String stringOutputType() default "base64";

    @AttributeDefinition(name="Password Provider Target", description="filter expression to target a Password Provider", required=false)
    public String passwordProvider_target();

    @AttributeDefinition(name="Security Provider Target", description="filter expression to target a Security Provider", required=false)
    public String securityProvider_target();

    @AttributeDefinition(name="IV Generator Target", description="filter expression to target an IV Generator", required=false)
    public String ivGenerator_target();

    @AttributeDefinition(name="Salt Generator Target", description="filter expression to target a Salt Generator", required=false)
    public String saltGenerator_target();

    public String webconsole_configurationFactory_nameHint() default "{names} {algorithm}";
}

