/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.jasypt.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import org.apache.sling.commons.crypto.jasypt.internal.JasyptRandomIvGeneratorRegistrarConfiguration;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Crypto \u2013 Jasypt Random IV Generator Registrar", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=JasyptRandomIvGeneratorRegistrarConfiguration.class, factory=true)
public class JasyptRandomIvGeneratorRegistrar {
    private ServiceRegistration<IvGenerator> serviceRegistration;
    private final Logger logger = LoggerFactory.getLogger(JasyptRandomIvGeneratorRegistrar.class);

    @Activate
    private void activate(JasyptRandomIvGeneratorRegistrarConfiguration configuration, BundleContext bundleContext) {
        this.logger.debug("activating");
        String algorithm = configuration.algorithm();
        RandomIvGenerator ivGenerator = new RandomIvGenerator(algorithm);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("algorithm", algorithm);
        this.logger.debug("registering Random IV Generator with algorithm {}", (Object)algorithm);
        this.serviceRegistration = bundleContext.registerService(IvGenerator.class, (Object)ivGenerator, properties);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        if (Objects.nonNull(this.serviceRegistration)) {
            this.serviceRegistration.unregister();
        }
    }
}

