/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import org.apache.sling.commons.crypto.PasswordProvider;
import org.apache.sling.commons.crypto.internal.FilePasswordProviderConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Crypto \u2013 File Password Provider", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=FilePasswordProviderConfiguration.class, factory=true)
public class FilePasswordProvider
implements PasswordProvider {
    private FilePasswordProviderConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(FilePasswordProvider.class);

    @Activate
    private void activate(FilePasswordProviderConfiguration configuration) throws IOException {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.checkConfiguration();
    }

    @Modified
    private void modified(FilePasswordProviderConfiguration configuration) throws IOException {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.checkConfiguration();
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.configuration = null;
    }

    private char[] readPassword(String path) throws IOException {
        File file = new File(path);
        char[] buffer = new char[(int)file.length()];
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            int size = reader.read(buffer);
            char[] password = new char[size];
            System.arraycopy(buffer, 0, password, 0, size);
            Arrays.fill(buffer, '0');
            char[] cArray = password;
            return cArray;
        }
    }

    private void checkConfiguration() throws IOException {
        String path = this.configuration.path();
        File file = new File(path);
        if (!file.canRead()) {
            String message = String.format("Unable to read password file '%s'", path);
            throw new IOException(message);
        }
    }

    @Override
    @NotNull
    public char[] getPassword() {
        try {
            return this.readPassword(this.configuration.path());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

