/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Objects;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.crypto.CryptoService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;

@Component(service={Servlet.class}, property={"felix.webconsole.label=sling-commons-crypto-encrypt", "felix.webconsole.title=Sling Commons Crypto Encrypt", "felix.webconsole.category=Crypto"})
public class EncryptWebConsolePlugin
extends HttpServlet {
    private BundleContext bundleContext;
    private ServiceTracker<CryptoService, CryptoService> tracker;
    private static final String PARAMETER_ID = "id";
    private static final String PARAMETER_MESSAGE = "message";
    private static final String ATTRIBUTE_CIPHERTEXT = "org.apache.sling.commons.crypto.internal.EncryptWebConsolePlugin.ciphertext";

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.tracker = new ServiceTracker(bundleContext, CryptoService.class, null);
        this.tracker.open();
    }

    @Deactivate
    private void deactivate() {
        this.bundleContext = null;
        if (Objects.nonNull(this.tracker)) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ciphertext;
        ServiceReference[] references = this.tracker.getServiceReferences();
        PrintWriter writer = response.getWriter();
        if (Objects.nonNull(references) && references.length > 0) {
            String form = this.buildForm(references);
            writer.println(form);
        } else {
            writer.println("<p>No crypto service available</p>");
        }
        String forwardRequestUri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (Objects.nonNull(forwardRequestUri) && forwardRequestUri.equals(request.getRequestURI()) && Objects.nonNull(ciphertext = (String)request.getAttribute(ATTRIBUTE_CIPHERTEXT))) {
            String html = String.format("<p>Encrypted message: %s</p>", ciphertext);
            writer.println(html);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.removeAttribute(ATTRIBUTE_CIPHERTEXT);
        String id = request.getParameter(PARAMETER_ID);
        String message = request.getParameter(PARAMETER_MESSAGE);
        if (Objects.isNull(id)) {
            this.handleParameterMissing(response, PARAMETER_ID);
            return;
        }
        if (Objects.isNull(message)) {
            this.handleParameterMissing(response, PARAMETER_MESSAGE);
            return;
        }
        CryptoService cryptoService = this.findCryptoService(id);
        if (Objects.isNull(cryptoService)) {
            this.handleCryptoServiceNotFound(response, id);
            return;
        }
        String ciphertext = cryptoService.encrypt(message);
        request.setAttribute(ATTRIBUTE_CIPHERTEXT, (Object)ciphertext);
        GetHttpServletRequestWrapper wrapper = new GetHttpServletRequestWrapper(request);
        request.getRequestDispatcher(request.getRequestURI()).forward((ServletRequest)wrapper, (ServletResponse)response);
    }

    private void handleParameterMissing(HttpServletResponse response, String parameter) throws IOException {
        String message = String.format("Parameter %s is missing", parameter);
        response.sendError(400, message);
    }

    private void handleCryptoServiceNotFound(HttpServletResponse response, String id) throws IOException {
        String message = String.format("Crypto service with component id %s not found", id);
        response.sendError(404, message);
    }

    @NotNull
    private String buildForm(ServiceReference<CryptoService>[] references) {
        StringBuilder builder = new StringBuilder();
        builder.append("<form method=\"POST\">");
        builder.append("<label for=\"message\">Message to encrypt</label>");
        builder.append("<br>");
        builder.append("<input type=\"text\" name=\"message\" id=\"message\">");
        builder.append("<br>");
        builder.append("<label>Available crypto services");
        builder.append("<br>");
        builder.append("<select name=\"id\">");
        for (ServiceReference<CryptoService> reference : references) {
            String id = reference.getProperty("component.id").toString();
            Object[] names = (String[])reference.getProperty("names");
            String algorithm = reference.getProperty("algorithm").toString();
            String label = String.format("Component id %s, names: %s, algorithm: %s", id, Arrays.toString(names), algorithm);
            builder.append("<option value=\"").append(id).append("\">");
            builder.append(label);
            builder.append("</option>");
        }
        builder.append("</label>");
        builder.append("</select>");
        builder.append("<br>");
        builder.append("<button type=\"submit\">encrypt</button>");
        builder.append("</form>");
        return builder.toString();
    }

    @Nullable
    private CryptoService findCryptoService(@NotNull String id) {
        ServiceReference[] references = this.tracker.getServiceReferences();
        if (Objects.isNull(references) || references.length == 0) {
            return null;
        }
        for (ServiceReference reference : references) {
            if (!id.equals(reference.getProperty("component.id").toString())) continue;
            return (CryptoService)this.bundleContext.getService(reference);
        }
        return null;
    }

    private static class GetHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        GetHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

