/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.contentdetection.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.contentdetection.FileNameExtractor;

@Component
@Service(value={FileNameExtractor.class})
@Properties(value={@Property(name="service.description", value={"Apache Sling Filename Extractor Service"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class FileNameExtractorImpl
implements FileNameExtractor {
    @Override
    public String extract(String name) {
        int percent;
        int backslash;
        int slash;
        int hash;
        int question = name.indexOf(63);
        if (question != -1) {
            name = name.substring(0, question);
        }
        if ((hash = name.indexOf(35)) != -1) {
            name = name.substring(0, hash);
        }
        if ((slash = name.lastIndexOf(47)) != -1) {
            name = name.substring(slash + 1);
        }
        if ((backslash = name.lastIndexOf(92)) != -1) {
            name = name.substring(backslash + 1);
        }
        if ((percent = name.indexOf(37)) != -1) {
            String encoding = this.getDefaultEncoding();
            try {
                name = URLDecoder.decode(name, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(encoding + " not supported??", e);
            }
        }
        name = name.trim();
        return name;
    }

    protected String getDefaultEncoding() {
        return "UTF-8";
    }
}

