/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal.models;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.cms.transformer.Transformation;
import org.apache.sling.cms.transformer.TransformationManager;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;

@Model(adaptables={Resource.class}, adapters={TransformationManager.class})
public class TransformationManagerImpl
implements TransformationManager {
    private Resource resource;
    @OSGiService
    private ConfigurationResourceResolver configResourceResolver;

    public TransformationManagerImpl(Resource resource) {
        this.resource = resource;
    }

    @Override
    public List<Transformation> getTransformations() {
        Collection transformationResources = this.configResourceResolver.getResourceCollection(this.resource, "files", "transformations");
        return transformationResources.stream().map(r -> (Transformation)r.adaptTo(Transformation.class)).collect(Collectors.toList());
    }
}

