/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import com.google.common.net.MediaType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.File;
import org.apache.sling.cms.transformer.ThumbnailProvider;
import org.osgi.service.component.annotations.Component;

@Component(service={ThumbnailProvider.class}, immediate=true)
public class PdfThumbnailProvider
implements ThumbnailProvider {
    @Override
    public boolean applies(Resource resource) {
        return ("sling:File".equals(resource.getResourceType()) || "nt:file".equals(resource.getResourceType())) && Optional.ofNullable((File)resource.adaptTo(File.class)).map(r -> MediaType.PDF.is(MediaType.parse((String)r.getContentType()))).orElse(false) != false;
    }

    @Override
    public InputStream getThumbnail(Resource resource) throws IOException {
        try (PDDocument document = PDDocument.load((InputStream)((InputStream)resource.adaptTo(InputStream.class)));){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "jpeg", os);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
    }
}

