/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.cms.transformer.ThumbnailProvider;
import org.apache.sling.cms.transformer.TransformationHandler;
import org.apache.sling.cms.transformer.Transformer;
import org.apache.sling.cms.transformer.internal.TransformerImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Web Console Plugin for Apache Sling CMS Transformer", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=slingcms-transformer", "felix.webconsole.title=Sling CMS Transformer", "felix.webconsole.configprinter.modes=always", "felix.webconsole.category=Status"}, service={Servlet.class})
public class TransformerWebConsole
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 4819043498961127418L;
    public static final String CONSOLE_LABEL = "slingcms-transformer";
    public static final String CONSOLE_TITLE = "Sling CMS Transformer";
    @Reference
    private transient Transformer transformer;

    public String getTitle() {
        return CONSOLE_TITLE;
    }

    public String getLabel() {
        return CONSOLE_LABEL;
    }

    protected void renderContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter pw = httpServletResponse.getWriter();
        pw.println("<div id='content' class='ui-widget'><br>");
        pw.println("<pre>");
        pw.println("Registered Thumbnail Providers");
        pw.println("========================");
        List<ThumbnailProvider> providers = ((TransformerImpl)this.transformer).getThumbnailProviders();
        Lists.reverse(providers).forEach(p -> pw.println(p.getClass().getName()));
        pw.println("</pre><br/>");
        pw.println("<pre>");
        pw.println("Registered Transformation Handlers");
        pw.println("========================");
        List<TransformationHandler> handlers = ((TransformerImpl)this.transformer).getHandlers();
        handlers.forEach(h -> pw.println(h.getResourceType() + "=" + h.getClass().getCanonicalName()));
        pw.println("</pre>");
        pw.println("</div>");
    }
}

