/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import java.io.IOException;
import java.io.InputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.transformer.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, property={"handler.resourceType=sling-cms/components/caconfig/transformationhandlers/crop"}, immediate=true)
public class CropHandler
implements TransformationHandler {
    public static final String PN_POSITION = "position";

    @Override
    public String getResourceType() {
        return "sling-cms/components/caconfig/transformationhandlers/crop";
    }

    @Override
    public void handle(Thumbnails.Builder<? extends InputStream> builder, Resource config) throws IOException {
        String positionStr = ((String)config.getValueMap().get(PN_POSITION, (Object)"CENTER")).toUpperCase();
        try {
            Positions pos = Positions.valueOf((String)positionStr);
            builder.crop((Position)pos);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Unable to load crop position from " + positionStr, e);
        }
    }
}

