/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.transformer.OutputFileFormat;
import org.apache.sling.cms.transformer.ThumbnailProvider;
import org.apache.sling.cms.transformer.Transformation;
import org.apache.sling.cms.transformer.TransformationHandler;
import org.apache.sling.cms.transformer.Transformer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Transformer.class})
public class TransformerImpl
implements Transformer {
    private static final Logger log = LoggerFactory.getLogger(TransformerImpl.class);
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    private List<TransformationHandler> handlers;
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    private List<ThumbnailProvider> thumbnailProviders;

    public void addThumbnailProvider(ThumbnailProvider thumbnailProvider) {
        if (this.thumbnailProviders == null) {
            this.thumbnailProviders = new ArrayList<ThumbnailProvider>();
        }
        this.thumbnailProviders.add(thumbnailProvider);
    }

    public void addTransformationHandler(TransformationHandler handler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList<TransformationHandler>();
        }
        this.handlers.add(handler);
    }

    public List<TransformationHandler> getHandlers() {
        return this.handlers;
    }

    private ThumbnailProvider getThumbnailProvider(Resource resource) throws IOException {
        return Lists.reverse(this.thumbnailProviders).stream().filter(tp -> tp.applies(resource)).findFirst().orElseThrow(() -> new IOException("Unable to find thumbnail provider for: " + resource.getPath()));
    }

    public List<ThumbnailProvider> getThumbnailProviders() {
        return this.thumbnailProviders;
    }

    public TransformationHandler getTransformationHandler(String resourceType) {
        return this.handlers.stream().filter(h -> resourceType.equals(h.getResourceType())).findFirst().orElse(null);
    }

    @Override
    public void transform(Resource resource, Transformation transformation, OutputFileFormat format, OutputStream out) throws IOException {
        ThumbnailProvider provider = this.getThumbnailProvider(resource);
        log.debug("Using thumbnail provider {} for resource {}", (Object)provider, (Object)resource);
        Thumbnails.Builder<? extends InputStream> builder = Thumbnails.of(provider.getThumbnail(resource));
        for (Resource config : transformation.getHandlers()) {
            log.debug("Handling command: {}", (Object)config);
            TransformationHandler handler = this.getTransformationHandler(config.getResourceType());
            if (handler != null) {
                log.debug("Invoking handler {} for command {}", (Object)handler.getClass().getCanonicalName(), (Object)config.getName());
                handler.handle(builder, config);
                continue;
            }
            log.info("No handler found for: {}", (Object)config.getName());
        }
        builder.outputFormat(format.toString());
        builder.toOutputStream(out);
    }
}

