/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.cms.transformer.OutputFileFormat;
import org.apache.sling.cms.transformer.Transformation;
import org.apache.sling.cms.transformer.Transformer;
import org.apache.sling.cms.transformer.internal.TransformationServiceUser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.extensions=transform", "sling.servlet.resourceTypes=sling:File", "sling.servlet.resourceTypes=nt:file"})
public class TransformServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TransformServlet.class);
    private static final long serialVersionUID = -1513067546618762171L;
    public static final String SERVICE_USER = "sling-cms-transformer";
    private transient TransformationServiceUser transformationServiceUser;
    private transient Transformer transformer;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        log.trace("doGet");
        String name = StringUtils.substringBeforeLast((String)request.getRequestPathInfo().getSuffix(), (String)".");
        String format = StringUtils.substringAfterLast((String)request.getRequestPathInfo().getSuffix(), (String)".");
        log.debug("Transforming resource: {} with transformation: {} to {}", new Object[]{request.getResource(), name, format});
        String original = response.getContentType();
        try (ResourceResolver serviceResolver = this.transformationServiceUser.getTransformationServiceUser();){
            Transformation transformation = this.findTransformation(serviceResolver, name);
            if (transformation != null) {
                response.setContentType(OutputFileFormat.forRequest(request).getMimeType());
                String expectedPath = "jcr:content/renditions/" + name + "." + format;
                Resource rendition = request.getResource().getChild(expectedPath);
                if (rendition != null) {
                    log.debug("Using existing rendition {}", (Object)name);
                    IOUtils.copy((InputStream)((InputStream)rendition.adaptTo(InputStream.class)), (OutputStream)response.getOutputStream());
                } else {
                    log.debug("Creating new rendition {}", (Object)name);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.transformer.transform(request.getResource(), transformation, OutputFileFormat.valueOf(format.toUpperCase()), baos);
                    IOUtils.copy((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)response.getOutputStream());
                    if ("sling:File".equals(request.getResource().getResourceType())) {
                        Resource file = ResourceUtil.getOrCreateResource((ResourceResolver)serviceResolver, (String)(request.getResource().getPath() + "/" + expectedPath), Collections.singletonMap("jcr:primaryType", "nt:file"), (String)"nt:unstructured", (boolean)false);
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        properties.put("jcr:primaryType", "nt:unstructured");
                        properties.put("jcr:data", new ByteArrayInputStream(baos.toByteArray()));
                        ResourceUtil.getOrCreateResource((ResourceResolver)serviceResolver, (String)(file.getPath() + "/" + "jcr:content"), properties, (String)"nt:unstructured", (boolean)true);
                    }
                }
            } else {
                log.error("Exception transforming image: {} with transformation: {}", (Object)request.getResource(), (Object)name);
                response.setContentType(original);
                response.sendError(400, "Could not transform image with transformation: " + name);
            }
        }
        catch (Exception e) {
            log.error("Exception rendering transformed resource", (Throwable)e);
            response.setContentType(original);
            response.sendError(500, "Could not transform image with transformation: " + name);
        }
    }

    protected Transformation findTransformation(ResourceResolver serviceResolver, String name) throws LoginException {
        name = name.substring(1).replace("'", "''");
        log.debug("Finding transformations with {}", (Object)name);
        Iterator transformations = serviceResolver.findResources("SELECT * FROM [nt:unstructured] WHERE ISDESCENDANTNODE([/conf]) AND [sling:resourceType]='sling-cms/components/caconfig/transformation' AND [name]='" + name + "'", "JCR-SQL2");
        if (transformations.hasNext()) {
            Resource transformation = (Resource)transformations.next();
            return (Transformation)transformation.adaptTo(Transformation.class);
        }
        return null;
    }

    @Reference
    public void setTransformationServiceUser(TransformationServiceUser transformationServiceUser) {
        this.transformationServiceUser = transformationServiceUser;
    }

    @Reference
    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }
}

