/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThumbnailatorUtils {
    private ThumbnailatorUtils() {
    }

    public static List<String> getSupportedOutputFormats() {
        String[] stringArray = ImageIO.getWriterFormatNames();
        if (stringArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(stringArray);
    }

    public static boolean isSupportedOutputFormat(String string) {
        if (string == ThumbnailParameter.ORIGINAL_FORMAT) {
            return true;
        }
        for (String string2 : ThumbnailatorUtils.getSupportedOutputFormats()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSupportedOutputFormatTypes(String string) {
        String[] stringArray;
        if (string == ThumbnailParameter.ORIGINAL_FORMAT) {
            return Collections.emptyList();
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        try {
            stringArray = iterator.next().getDefaultWriteParam().getCompressionTypes();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Collections.emptyList();
        }
        if (stringArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(stringArray);
    }

    public static boolean isSupportedOutputFormatType(String string, String string2) {
        if (!ThumbnailatorUtils.isSupportedOutputFormat(string)) {
            return false;
        }
        if (string == ThumbnailParameter.ORIGINAL_FORMAT && string2 == ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return true;
        }
        if (string == ThumbnailParameter.ORIGINAL_FORMAT && string2 != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return false;
        }
        if (string2 == ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
            return true;
        }
        for (String string3 : ThumbnailatorUtils.getSupportedOutputFormatTypes(string)) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

