/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.cms.transformer.FileThumbnailTransformer;
import org.apache.sling.cms.transformer.OutputFileFormat;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.extensions=transform", "sling.servlet.resourceTypes=sling:File", "sling.servlet.resourceTypes=nt:file"})
public class TransformServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TransformServlet.class);
    private static final long serialVersionUID = -1513067546618762171L;
    @Reference
    private transient FileThumbnailTransformer transformer;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String original = response.getContentType();
        try {
            response.setContentType(OutputFileFormat.forRequest(request).getMimeType());
            this.transformer.transformFile(request, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("Exception transforming image", (Throwable)e);
            response.setContentType(original);
            response.sendError(400, "Could not transform image with provided commands");
        }
    }
}

