/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import org.apache.sling.cms.File;
import org.apache.sling.cms.transformer.OutputFileFormat;
import org.apache.sling.cms.transformer.ThumbnailProvider;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Component(service={ThumbnailProvider.class}, property={"service.ranking=-2147483648"})
public class TikaFallbackProvider
implements ThumbnailProvider {
    private static final Logger log = LoggerFactory.getLogger(TikaFallbackProvider.class);

    @Override
    public boolean applies(File file) {
        return true;
    }

    @Override
    public InputStream getThumbnail(File file) throws IOException {
        log.info("Extracting content thumbnail from {}", (Object)file.getPath());
        try {
            log.debug("Extracting file contents");
            InputStream is = (InputStream)file.getResource().adaptTo(InputStream.class);
            AutoDetectParser parser = new AutoDetectParser();
            BodyContentHandler handler = new BodyContentHandler();
            Metadata md = new Metadata();
            ParseContext context = new ParseContext();
            parser.parse(is, (ContentHandler)handler, md, context);
            log.debug("Creating thumbnail of file contents");
            int width = 500;
            int height = 500;
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D graphics = image.createGraphics();
            JEditorPane jep = new JEditorPane("text/html", handler.toString());
            jep.setSize(width, height);
            jep.print(graphics);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, OutputFileFormat.PNG.toString(), baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (TikaException | SAXException e) {
            throw new IOException("Failed to generate thumbnail from " + file.getPath(), e);
        }
    }
}

