/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import java.io.IOException;
import java.io.InputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.sling.cms.transformer.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class})
public class SizeHandler
implements TransformationHandler {
    @Override
    public boolean applies(String command) {
        return command.startsWith("size-");
    }

    @Override
    public void handle(Thumbnails.Builder<? extends InputStream> builder, String cmd) throws IOException {
        int width = -1;
        try {
            width = Integer.parseInt(cmd.split("\\-")[1], 10);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Failed to get width from " + cmd.split("\\-")[1]);
        }
        int height = -1;
        try {
            height = Integer.parseInt(cmd.split("\\-")[2], 10);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Failed to get height from " + cmd.split("\\-")[2]);
        }
        builder.size(width, height);
    }
}

