/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import com.google.common.net.MediaType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.sling.cms.File;
import org.apache.sling.cms.transformer.ThumbnailProvider;
import org.osgi.service.component.annotations.Component;

@Component(service={ThumbnailProvider.class})
public class PdfThumbnailProvider
implements ThumbnailProvider {
    @Override
    public boolean applies(File file) {
        return MediaType.PDF.is(MediaType.parse((String)file.getContentType()));
    }

    @Override
    public InputStream getThumbnail(File file) throws IOException {
        try (PDDocument document = PDDocument.load((InputStream)((InputStream)file.getResource().adaptTo(InputStream.class)));){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "jpeg", os);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
    }
}

