/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.cms.File;
import org.apache.sling.cms.transformer.FileThumbnailTransformer;
import org.apache.sling.cms.transformer.OutputFileFormat;
import org.apache.sling.cms.transformer.ThumbnailProvider;
import org.apache.sling.cms.transformer.TransformationHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileThumbnailTransformer.class})
public class FileThumbnailTransformerImpl
implements FileThumbnailTransformer {
    private static final Logger log = LoggerFactory.getLogger(FileThumbnailTransformerImpl.class);
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    private List<TransformationHandler> handlers;
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    private List<ThumbnailProvider> thumbnailProviders;

    public List<TransformationHandler> getHandlers() {
        return this.handlers;
    }

    private ThumbnailProvider getThumbnailProvider(File file) throws IOException {
        return Lists.reverse(this.thumbnailProviders).stream().filter(tp -> tp.applies(file)).findFirst().orElseThrow(() -> new IOException("Unable to find thumbnail provider for: " + file.getPath()));
    }

    public List<ThumbnailProvider> getThumbnailProviders() {
        return this.thumbnailProviders;
    }

    @Override
    public TransformationHandler getTransformationHandler(String command) {
        return this.handlers.stream().filter(h -> h.applies(command)).findFirst().orElse(null);
    }

    public void setHandlers(List<TransformationHandler> handlers) {
        this.handlers = handlers;
    }

    public void setThumbnailProviders(List<ThumbnailProvider> thumbnailProviders) {
        this.thumbnailProviders = thumbnailProviders;
    }

    @Override
    public void transformFile(File file, String[] commands, OutputFileFormat format, OutputStream out) throws IOException {
        ThumbnailProvider provider = this.getThumbnailProvider(file);
        log.debug("Using thumbnail provider {} for file {}", (Object)provider, (Object)file);
        Thumbnails.Builder<? extends InputStream> builder = Thumbnails.of(provider.getThumbnail(file));
        for (String command : commands) {
            if (!StringUtils.isNotBlank((CharSequence)command)) continue;
            log.debug("Handling command: {}", (Object)command);
            TransformationHandler handler = this.getTransformationHandler(command);
            if (handler != null) {
                log.debug("Invoking handler {} for command {}", (Object)handler.getClass().getCanonicalName(), (Object)command);
                handler.handle(builder, command);
                continue;
            }
            log.info("No handler found for: {}", (Object)command);
        }
        builder.outputFormat(format.toString());
        builder.toOutputStream(out);
    }

    @Override
    public void transformFile(SlingHttpServletRequest request, OutputStream out) throws IOException {
        OutputFileFormat fileFormat = OutputFileFormat.forRequest(request);
        this.transformFile((File)request.getResource().adaptTo(File.class), Optional.ofNullable(request.getRequestPathInfo().getSuffix()).map(s -> StringUtils.substringBeforeLast((String)s, (String)".")).map(s -> s.split("/")).orElse(new String[0]), fileFormat, out);
    }
}

