/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.transformer;

import com.google.common.base.Enums;
import com.google.common.net.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;

public enum OutputFileFormat {
    GIF(MediaType.GIF.toString()),
    JPEG(MediaType.JPEG.toString()),
    PNG(MediaType.PNG.toString());

    private String mimeType;

    public static OutputFileFormat forRequest(SlingHttpServletRequest request) {
        String suffixExtension = StringUtils.substringAfterLast((String)request.getRequestPathInfo().getSuffix(), (String)".").toUpperCase();
        return (OutputFileFormat)((Object)Enums.getIfPresent(OutputFileFormat.class, (String)suffixExtension).or((Object)JPEG));
    }

    private OutputFileFormat(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

