/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class Search {
    private static final Logger log = LoggerFactory.getLogger(Search.class);
    public static final String TERM_PARAMETER = "q";
    @ValueMapValue
    private String basePath;
    private int count;
    private int end;
    @ValueMapValue
    private int limit;
    private int page;
    private Integer[] pages;
    private SlingHttpServletRequest request;
    private List<Resource> results = new ArrayList<Resource>();
    private int start;

    public Search(SlingHttpServletRequest request) {
        this.request = request;
    }

    public int getCount() {
        return this.count;
    }

    public int getCurrentPage() {
        return this.page + 1;
    }

    public int getEnd() {
        return this.end;
    }

    public Integer[] getPages() {
        return this.pages;
    }

    public List<Resource> getResults() {
        return this.results;
    }

    public int getStart() {
        return this.start;
    }

    public String getTerm() {
        return this.request.getParameter(TERM_PARAMETER);
    }

    @PostConstruct
    public void init() {
        HashSet<String> distinct = new HashSet<String>();
        String term = Text.escapeIllegalXpathSearchChars((String)this.request.getParameter(TERM_PARAMETER)).replaceAll("'", "''");
        String query = "SELECT * FROM [sling:Page] AS p WHERE [jcr:content/published]=true AND (p.[jcr:content/hideInSitemap] IS NULL OR p.[jcr:content/hideInSitemap] <> true) AND ISDESCENDANTNODE(p, '" + this.basePath + "') AND CONTAINS(p.*, '" + term + "') ORDER BY [jcr:score]";
        log.debug("Searching for pages with {} under {} with query: {}", new Object[]{term, this.basePath, query});
        Iterator res = this.request.getResourceResolver().findResources(query, "JCR-SQL2");
        while (res.hasNext()) {
            Resource result = (Resource)res.next();
            if (distinct.contains(result.getPath())) continue;
            this.results.add(result);
            distinct.add(result.getPath());
        }
        this.count = this.results.size();
        log.debug("Found {} results", (Object)this.count);
        if (StringUtils.isNotBlank((String)this.request.getParameter("page")) && this.request.getParameter("page").matches("\\d+")) {
            this.page = Integer.parseInt(this.request.getParameter("page"), 10) - 1;
            log.debug("Using page {}", (Object)this.page);
        } else {
            this.page = 0;
            log.debug("Page {} not specified or not valid", (Object)this.request.getParameter("page"));
        }
        this.start = this.page * this.limit >= this.count ? this.count : this.page * this.limit;
        log.debug("Using start {}", (Object)this.start);
        this.end = this.page * this.limit + this.limit >= this.count ? this.count : this.page * this.limit + this.limit;
        log.debug("Using end {}", (Object)this.end);
        this.results = this.results.subList(this.start, this.end);
        ArrayList<Integer> pgs = new ArrayList<Integer>();
        int max = (int)Math.ceil((double)this.count / (double)this.limit) + 1;
        for (int i = 1; i < max; ++i) {
            pgs.add(i);
        }
        this.pages = pgs.toArray(new Integer[pgs.size()]);
        log.debug("Loaded pages {}", (Object)Arrays.toString((Object[])this.pages));
    }

    public boolean isFirst() {
        return this.page == 0;
    }

    public boolean isLast() {
        if (this.pages.length > 0) {
            return this.page + 1 == this.pages[this.pages.length - 1];
        }
        return true;
    }
}

