/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.providers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.reference.forms.FormValueProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormValueProvider.class})
public class UserProfileFormValueProvider
implements FormValueProvider {
    private static final Logger log = LoggerFactory.getLogger(UserProfileFormValueProvider.class);

    @Override
    public void loadValues(Resource providerResource, Map<String, Object> formData) {
        log.trace("loadFormData");
        try {
            ResourceResolver resolver = providerResource.getResourceResolver();
            String userId = resolver.getUserID();
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            if (session != null) {
                UserManager userManager = session.getUserManager();
                User user = (User)userManager.getAuthorizable(userId);
                String subpath = (String)providerResource.getValueMap().get("subpath", (Object)"profile");
                log.debug("Loading profile data from: {}/{}", (Object)user.getPath(), (Object)subpath);
                Iterator keys = user.getPropertyNames(subpath);
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    log.debug("Loading key {}", (Object)key);
                    this.loadKey(formData, subpath, key, user);
                }
            } else {
                log.warn("Failed to load Jackrabbit session for request");
            }
        }
        catch (RepositoryException e) {
            log.warn("Exception loading values from user profile", (Throwable)e);
        }
    }

    private void loadKey(Map<String, Object> formData, String subpath, String key, User user) {
        Object value = null;
        try {
            Value[] v = user.getProperty(subpath + "/" + key);
            value = v.length > 1 ? Arrays.stream(v).map(t -> {
                try {
                    return t.getString();
                }
                catch (IllegalStateException | RepositoryException e) {
                    log.warn("Failed to get string value for " + key, e);
                    return null;
                }
            }).collect(Collectors.toList()).toArray(new String[0]) : (v[0].getType() == 3 ? Long.valueOf(v[0].getLong()) : (v[0].getType() == 4 ? Double.valueOf(v[0].getDouble()) : (v[0].getType() == 5 ? v[0].getDate() : v[0].getString())));
            formData.put(key, value);
        }
        catch (RepositoryException e) {
            log.warn("Failed to get string value for " + key, (Throwable)e);
        }
    }

    @Override
    public boolean handles(Resource valueProviderResource) {
        return "reference/components/forms/providers/userprofile".equals(valueProviderResource.getResourceType());
    }
}

