/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.cms.ResourceTree;
import org.apache.sling.cms.reference.forms.FieldHandler;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.apache.sling.cms.reference.forms.FormValueProvider;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={FormRequest.class})
public class FormRequestImpl
implements FormRequest {
    private static final Logger log = LoggerFactory.getLogger(FormRequestImpl.class);
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private List<FieldHandler> fieldHandlers;
    private Map<String, Object> formData = new HashMap<String, Object>();
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private List<FormValueProvider> formValueProvider;
    private final boolean loadProviders;
    private SlingHttpServletRequest request;

    public FormRequestImpl(SlingHttpServletRequest request) throws FormException {
        this.request = request;
        this.loadProviders = true;
    }

    public FormRequestImpl(SlingHttpServletRequest request, boolean loadProviders) throws FormException {
        this.request = request;
        this.loadProviders = loadProviders;
    }

    @Override
    public ValueMap getFormData() {
        return new ValueMapDecorator(this.formData);
    }

    @Override
    public Resource getFormResource() {
        return this.request.getResource();
    }

    @Override
    public SlingHttpServletRequest getOriginalRequest() {
        return this.request;
    }

    @PostConstruct
    public void init() throws FormException {
        if (this.request.getSession().getAttribute(this.getSessionId()) != null) {
            this.formData.putAll((Map)this.request.getSession().getAttribute(this.getSessionId()));
        }
        if (this.loadProviders && this.getFormResource().getChild("providers") != null) {
            List providers = ResourceTree.stream((Resource)this.getFormResource().getChild("providers")).map(ResourceTree::getResource).collect(Collectors.toList());
            block0: for (Resource provider : providers) {
                log.debug("Looking for handler for: {}", (Object)provider);
                if (this.formValueProvider == null) continue;
                for (FormValueProvider fvp : this.formValueProvider) {
                    if (!fvp.handles(provider)) continue;
                    log.debug("Invoking field value provider: {}", fvp.getClass());
                    fvp.loadValues(provider, this.formData);
                    continue block0;
                }
            }
        }
    }

    public void initFields() throws FormException {
        List fields = ResourceTree.stream((Resource)this.getFormResource().getChild("fields")).map(ResourceTree::getResource).collect(Collectors.toList());
        block0: for (Resource field : fields) {
            log.debug("Looking for handler for: {}", (Object)field);
            for (FieldHandler fieldHandler : this.fieldHandlers) {
                if (!fieldHandler.handles(field)) continue;
                log.debug("Invoking field handler: {}", fieldHandler.getClass());
                fieldHandler.handleField(this.request, field, this.formData);
                continue block0;
            }
        }
    }

    @Override
    public String getSessionId() {
        return "errorval-" + this.getOriginalRequest().getResource().getPath();
    }
}

