/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.fields;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.reference.forms.FieldHandler;
import org.apache.sling.cms.reference.forms.FormException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FieldHandler.class})
public class TextfieldHandler
implements FieldHandler {
    private static final Logger log = LoggerFactory.getLogger(TextfieldHandler.class);
    private static final Map<String, String> typePatterns = new HashMap<String, String>();
    private static final Map<String, String> dateFormats;

    @Override
    public boolean handles(Resource fieldResource) {
        String resourceType = fieldResource.getResourceType();
        return "reference/components/forms/fields/textfield".equals(resourceType);
    }

    @Override
    public void handleField(SlingHttpServletRequest request, Resource fieldResource, Map<String, Object> formData) throws FormException {
        log.trace("handleField");
        String name = FieldHandler.getName(fieldResource);
        String value = request.getParameter(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            if (FieldHandler.isRequired(fieldResource)) {
                throw new FormException("Field " + name + " not set and is required");
            }
            log.debug("Ignoring unset value: {}", (Object)name);
        } else {
            this.validateValue(fieldResource, value);
            log.debug("Setting value for: {}", (Object)name);
            String saveAs = (String)fieldResource.getValueMap().get("saveAs", (Object)"string");
            if ("date".equals(saveAs)) {
                String type = (String)fieldResource.getValueMap().get("type", String.class);
                if (!dateFormats.containsKey(type)) {
                    throw new FormException("Field " + name + " is not a date type");
                }
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new SimpleDateFormat(dateFormats.get(type)).parse(value));
                    formData.put(name, cal);
                }
                catch (ParseException e) {
                    throw new FormException("Failed to parse date from " + value);
                }
            } else if ("double".equals(saveAs)) {
                try {
                    formData.put(name, Double.parseDouble(value));
                }
                catch (NumberFormatException nfe) {
                    throw new FormException("Failed to parse double from " + value);
                }
            } else if ("integer".equals(saveAs)) {
                try {
                    formData.put(name, Integer.parseInt(value, 10));
                }
                catch (NumberFormatException nfe) {
                    throw new FormException("Failed to parse integer from " + value);
                }
            } else {
                formData.put(name, value);
            }
        }
    }

    protected void validateValue(Resource fieldResource, String value) throws FormException {
        String pattern = (String)fieldResource.getValueMap().get("pattern", String.class);
        if (StringUtils.isNotBlank((CharSequence)pattern) && !value.matches(pattern)) {
            throw new FormException("Field " + FieldHandler.getName(fieldResource) + " does not match pattern " + pattern);
        }
        String type = (String)fieldResource.getValueMap().get("type", String.class);
        if (typePatterns.containsKey(type) && !value.matches(typePatterns.get(type))) {
            throw new FormException("Field " + FieldHandler.getName(fieldResource) + " is not a valid " + type);
        }
        if ("number".equals(type) && !NumberUtils.isCreatable((String)value)) {
            throw new FormException("Field " + FieldHandler.getName(fieldResource) + " is not a number");
        }
    }

    static {
        typePatterns.put("date", "\\d{4}-\\d{2}-\\d{2}");
        typePatterns.put("datetime-local", "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}");
        typePatterns.put("email", ".+@.+");
        typePatterns.put("time", "\\d{2}:\\d{2}(:\\d{2})?");
        dateFormats = new HashMap<String, String>();
        dateFormats.put("date", "yyyy-MM-dd");
        dateFormats.put("datetime-local", "yyyy-MM-ddThh:mm");
    }
}

