/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.fields;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.reference.forms.FieldHandler;
import org.apache.sling.cms.reference.forms.FormException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FieldHandler.class})
public class TextareaHandler
implements FieldHandler {
    private static final Logger log = LoggerFactory.getLogger(TextareaHandler.class);

    @Override
    public boolean handles(Resource fieldResource) {
        String resourceType = fieldResource.getResourceType();
        return "reference/components/forms/fields/textarea".equals(resourceType);
    }

    @Override
    public void handleField(SlingHttpServletRequest request, Resource fieldResource, Map<String, Object> formData) throws FormException {
        log.trace("handleField");
        String name = FieldHandler.getName(fieldResource);
        String value = request.getParameter(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            if (FieldHandler.isRequired(fieldResource)) {
                throw new FormException("Field " + name + " not set and is required");
            }
            log.debug("Ignoring unset value: {}", (Object)name);
        } else {
            log.debug("Setting value for: {}", (Object)name);
            formData.put(name, value);
        }
    }
}

