/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.text.StringSubstitutor;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.NameFilter;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.apache.sling.cms.usergenerated.UGCBucketConfig;
import org.apache.sling.cms.usergenerated.UserGeneratedContentService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class}, immediate=true)
public class UserGeneratedContentAction
implements FormAction {
    private static final Logger log = LoggerFactory.getLogger(UserGeneratedContentAction.class);
    @Reference
    private NameFilter filter;
    @Reference
    private UserGeneratedContentService ugcService;

    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        log.trace("handleForm");
        ValueMap properties = actionResource.getValueMap();
        try {
            UGCBucketConfig bucketConfig = new UGCBucketConfig();
            bucketConfig.setAction(UserGeneratedContentService.APPROVE_ACTION.valueOf((String)((String)properties.get("approveAction", (Object)UserGeneratedContentService.APPROVE_ACTION.PUBLISH.toString()))));
            bucketConfig.setBucket((String)properties.get("bucket", String.class));
            bucketConfig.setContentType(UserGeneratedContentService.CONTENT_TYPE.valueOf((String)((String)properties.get("contentType", (Object)UserGeneratedContentService.CONTENT_TYPE.OTHER.toString()))));
            bucketConfig.setPathDepth(((Integer)properties.get("pathDepth", (Object)0)).intValue());
            log.debug("Creating UGC at with configuration:  {}", (Object)bucketConfig);
            StringSubstitutor sub = new StringSubstitutor((Map)request.getFormData());
            HashMap<String, String> contentProperties = new HashMap<String, String>();
            contentProperties.put("jcr:primaryType", "nt:unstructured");
            Arrays.stream((Object[])properties.get("additionalProperties", (Object)new String[0])).map(v -> {
                if (v.contains("=")) {
                    String[] vs = v.split("\\=");
                    return new ImmutablePair((Object)vs[0], (Object)vs[1]);
                }
                log.warn("Invalid value: {}", v);
                return null;
            }).forEach(v -> {
                log.debug("Adding additional property: {}", v);
                contentProperties.put((String)v.getLeft(), (String)v.getRight());
            });
            contentProperties.putAll((Map<String, String>)request.getFormData());
            log.debug("Persisting properties: {}", contentProperties);
            Resource container = this.ugcService.createUGCContainer(request.getOriginalRequest(), bucketConfig, sub.replace((String)properties.get("preview", (Object)"")), (String)properties.get("targetPath", (Object)""));
            log.debug("Using container: {}", (Object)container);
            ResourceResolver resolver = container.getResourceResolver();
            String name = this.filter.filter(sub.replace((String)properties.get("name", (Object)"")));
            log.debug("Using name {}", (Object)name);
            if (((Boolean)properties.get("wrapPage", (Object)false)).booleanValue()) {
                log.debug("Wrapping with page");
                Resource page = container.getResourceResolver().create(container, name, Collections.singletonMap("jcr:primaryType", "sling:Page"));
                resolver.create(page, "jcr:content", contentProperties);
            } else {
                log.debug("Creating as direct child");
                resolver.create(container, name, contentProperties);
            }
            resolver.commit();
            log.debug("Successfully persisted UGC");
            return FormActionResult.success("Created UGC Item");
        }
        catch (PersistenceException e) {
            throw new FormException("Failed to create UGC Content", e);
        }
    }

    @Override
    public boolean handles(Resource actionResource) {
        return "reference/components/forms/actions/usergeneratedcontent".equals(actionResource.getResourceType());
    }
}

