/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.util.HashMap;
import java.util.Map;
import javax.mail.Authenticator;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.apache.sling.cms.reference.forms.impl.actions.SendEmailActonConfig;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class, JobConsumer.class}, property={"job.topics=reference/form/sendemail"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=SendEmailActonConfig.class)
public class SendEmailAction
implements JobConsumer,
FormAction {
    public static final String FROM = "from";
    private static final Logger log = LoggerFactory.getLogger(SendEmailAction.class);
    public static final String MESSAGE = "message";
    public static final String SUBJECT = "subject";
    public static final String TO = "to";
    public static final String TOPIC = "reference/form/sendemail";
    private SendEmailActonConfig config;
    @Reference
    private JobManager jobManager;

    @Activate
    public void activate(SendEmailActonConfig config) {
        this.config = config;
    }

    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        StrSubstitutor sub = new StrSubstitutor((Map)request.getFormData());
        ValueMap properties = actionResource.getValueMap();
        String to = sub.replace((String)properties.get(TO, String.class));
        log.debug("Queueing contact message to {}", (Object)to);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(SUBJECT, sub.replace((String)properties.get(SUBJECT, String.class)));
        data.put(MESSAGE, sub.replace((String)properties.get(MESSAGE, String.class)));
        data.put(TO, to);
        data.put(FROM, sub.replace((String)properties.get(FROM, String.class)));
        this.jobManager.addJob(TOPIC, data);
        log.debug("Job queued successfully!");
        return FormActionResult.success("Email queued successfully!");
    }

    @Override
    public boolean handles(Resource actionResource) {
        return "reference/components/forms/actions/sendemail".equals(actionResource.getResourceType());
    }

    public JobConsumer.JobResult process(Job job) {
        log.trace("process");
        try {
            log.debug("Configuring connection to {}:{} with username {}", new Object[]{this.config.hostName(), this.config.smtpPort(), this.config.username()});
            SimpleEmail email = new SimpleEmail();
            email.setHostName(this.config.hostName());
            email.setSmtpPort(this.config.smtpPort());
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.config.username(), this.config.password()));
            email.setStartTLSEnabled(this.config.tlsEnabled());
            String from = (String)job.getProperty(FROM, String.class);
            String to = (String)job.getProperty(TO, String.class);
            String subject = (String)job.getProperty(SUBJECT, String.class);
            String message = (String)job.getProperty(MESSAGE, String.class);
            log.debug("Sending email from {} to {} with subject {}", new Object[]{from, to, subject});
            email.setFrom(from);
            email.setSubject(subject);
            email.setMsg(message);
            email.addTo(to);
            email.send();
        }
        catch (EmailException e) {
            log.warn("Exception sending email for job " + job.getId(), (Throwable)e);
            return JobConsumer.JobResult.FAILED;
        }
        return JobConsumer.JobResult.OK;
    }
}

